package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "unifiedRoles"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminAccessDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("unifiedRoles")
    protected List<UnifiedRole> unifiedRoles;

    @JsonProperty("unifiedRoles@nextLink")
    protected String unifiedRolesNextLink;

    protected DelegatedAdminAccessDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminAccessDetails";
    }

    @Property(name="unifiedRoles")
    @JsonIgnore
    public CollectionPage<UnifiedRole> getUnifiedRoles() {
        return new CollectionPage<UnifiedRole>(contextPath, UnifiedRole.class, this.unifiedRoles, Optional.ofNullable(unifiedRolesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="unifiedRoles")
    @JsonIgnore
    public CollectionPage<UnifiedRole> getUnifiedRoles(HttpRequestOptions options) {
        return new CollectionPage<UnifiedRole>(contextPath, UnifiedRole.class, this.unifiedRoles, Optional.ofNullable(unifiedRolesNextLink), Collections.emptyList(), options);
    }

    public DelegatedAdminAccessDetails withUnmappedField(String name, Object value) {
        DelegatedAdminAccessDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<UnifiedRole> unifiedRoles;
        private String unifiedRolesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder unifiedRoles(List<UnifiedRole> unifiedRoles) {
            this.unifiedRoles = unifiedRoles;
            this.changedFields = changedFields.add("unifiedRoles");
            return this;
        }

        public Builder unifiedRoles(UnifiedRole... unifiedRoles) {
            return unifiedRoles(Arrays.asList(unifiedRoles));
        }

        public Builder unifiedRolesNextLink(String unifiedRolesNextLink) {
            this.unifiedRolesNextLink = unifiedRolesNextLink;
            this.changedFields = changedFields.add("unifiedRoles");
            return this;
        }

        public DelegatedAdminAccessDetails build() {
            DelegatedAdminAccessDetails _x = new DelegatedAdminAccessDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminAccessDetails";
            _x.unifiedRoles = unifiedRoles;
            _x.unifiedRolesNextLink = unifiedRolesNextLink;
            return _x;
        }
    }

    private DelegatedAdminAccessDetails _copy() {
        DelegatedAdminAccessDetails _x = new DelegatedAdminAccessDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.unifiedRoles = unifiedRoles;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminAccessDetails[");
        b.append("unifiedRoles=");
        b.append(this.unifiedRoles);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
