package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DelegatedAdminAccessContainerType;

@JsonPropertyOrder({
    "@odata.type", 
    "accessContainerId", 
    "accessContainerType"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminAccessContainer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessContainerId")
    protected String accessContainerId;

    @JsonProperty("accessContainerType")
    protected DelegatedAdminAccessContainerType accessContainerType;

    protected DelegatedAdminAccessContainer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminAccessContainer";
    }

    @Property(name="accessContainerId")
    @JsonIgnore
    public Optional<String> getAccessContainerId() {
        return Optional.ofNullable(accessContainerId);
    }

    public DelegatedAdminAccessContainer withAccessContainerId(String accessContainerId) {
        DelegatedAdminAccessContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessContainer");
        _x.accessContainerId = accessContainerId;
        return _x;
    }

    @Property(name="accessContainerType")
    @JsonIgnore
    public Optional<DelegatedAdminAccessContainerType> getAccessContainerType() {
        return Optional.ofNullable(accessContainerType);
    }

    public DelegatedAdminAccessContainer withAccessContainerType(DelegatedAdminAccessContainerType accessContainerType) {
        DelegatedAdminAccessContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessContainer");
        _x.accessContainerType = accessContainerType;
        return _x;
    }

    public DelegatedAdminAccessContainer withUnmappedField(String name, Object value) {
        DelegatedAdminAccessContainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String accessContainerId;
        private DelegatedAdminAccessContainerType accessContainerType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessContainerId(String accessContainerId) {
            this.accessContainerId = accessContainerId;
            this.changedFields = changedFields.add("accessContainerId");
            return this;
        }

        public Builder accessContainerType(DelegatedAdminAccessContainerType accessContainerType) {
            this.accessContainerType = accessContainerType;
            this.changedFields = changedFields.add("accessContainerType");
            return this;
        }

        public DelegatedAdminAccessContainer build() {
            DelegatedAdminAccessContainer _x = new DelegatedAdminAccessContainer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminAccessContainer";
            _x.accessContainerId = accessContainerId;
            _x.accessContainerType = accessContainerType;
            return _x;
        }
    }

    private DelegatedAdminAccessContainer _copy() {
        DelegatedAdminAccessContainer _x = new DelegatedAdminAccessContainer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessContainerId = accessContainerId;
        _x.accessContainerType = accessContainerType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminAccessContainer[");
        b.append("accessContainerId=");
        b.append(this.accessContainerId);
        b.append(", ");
        b.append("accessContainerType=");
        b.append(this.accessContainerType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
