package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DecisionItemPrincipalResourceMembershipType;

@JsonPropertyOrder({
    "@odata.type", 
    "membershipType"})
@JsonInclude(Include.NON_NULL)
public class DecisionItemPrincipalResourceMembership implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("membershipType")
    protected DecisionItemPrincipalResourceMembershipType membershipType;

    protected DecisionItemPrincipalResourceMembership() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.decisionItemPrincipalResourceMembership";
    }

    @Property(name="membershipType")
    @JsonIgnore
    public Optional<DecisionItemPrincipalResourceMembershipType> getMembershipType() {
        return Optional.ofNullable(membershipType);
    }

    public DecisionItemPrincipalResourceMembership withMembershipType(DecisionItemPrincipalResourceMembershipType membershipType) {
        DecisionItemPrincipalResourceMembership _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.decisionItemPrincipalResourceMembership");
        _x.membershipType = membershipType;
        return _x;
    }

    public DecisionItemPrincipalResourceMembership withUnmappedField(String name, Object value) {
        DecisionItemPrincipalResourceMembership _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DecisionItemPrincipalResourceMembershipType membershipType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder membershipType(DecisionItemPrincipalResourceMembershipType membershipType) {
            this.membershipType = membershipType;
            this.changedFields = changedFields.add("membershipType");
            return this;
        }

        public DecisionItemPrincipalResourceMembership build() {
            DecisionItemPrincipalResourceMembership _x = new DecisionItemPrincipalResourceMembership();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.decisionItemPrincipalResourceMembership";
            _x.membershipType = membershipType;
            return _x;
        }
    }

    private DecisionItemPrincipalResourceMembership _copy() {
        DecisionItemPrincipalResourceMembership _x = new DecisionItemPrincipalResourceMembership();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.membershipType = membershipType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DecisionItemPrincipalResourceMembership[");
        b.append("membershipType=");
        b.append(this.membershipType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
