package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayAs", 
    "format"})
@JsonInclude(Include.NON_NULL)
public class DateTimeColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayAs")
    protected String displayAs;

    @JsonProperty("format")
    protected String format;

    protected DateTimeColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dateTimeColumn";
    }

    @Property(name="displayAs")
    @JsonIgnore
    public Optional<String> getDisplayAs() {
        return Optional.ofNullable(displayAs);
    }

    public DateTimeColumn withDisplayAs(String displayAs) {
        DateTimeColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dateTimeColumn");
        _x.displayAs = displayAs;
        return _x;
    }

    @Property(name="format")
    @JsonIgnore
    public Optional<String> getFormat() {
        return Optional.ofNullable(format);
    }

    public DateTimeColumn withFormat(String format) {
        DateTimeColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dateTimeColumn");
        _x.format = format;
        return _x;
    }

    public DateTimeColumn withUnmappedField(String name, Object value) {
        DateTimeColumn _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayAs;
        private String format;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            this.changedFields = changedFields.add("displayAs");
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            this.changedFields = changedFields.add("format");
            return this;
        }

        public DateTimeColumn build() {
            DateTimeColumn _x = new DateTimeColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dateTimeColumn";
            _x.displayAs = displayAs;
            _x.format = format;
            return _x;
        }
    }

    private DateTimeColumn _copy() {
        DateTimeColumn _x = new DateTimeColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayAs = displayAs;
        _x.format = format;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DateTimeColumn[");
        b.append("displayAs=");
        b.append(this.displayAs);
        b.append(", ");
        b.append("format=");
        b.append(this.format);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
