package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "email", 
    "firstName", 
    "lastName", 
    "residency"})
@JsonInclude(Include.NON_NULL)
public class DataSubject implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("firstName")
    protected String firstName;

    @JsonProperty("lastName")
    protected String lastName;

    @JsonProperty("residency")
    protected String residency;

    protected DataSubject() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataSubject";
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public DataSubject withEmail(String email) {
        DataSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSubject");
        _x.email = email;
        return _x;
    }

    @Property(name="firstName")
    @JsonIgnore
    public Optional<String> getFirstName() {
        return Optional.ofNullable(firstName);
    }

    public DataSubject withFirstName(String firstName) {
        DataSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSubject");
        _x.firstName = firstName;
        return _x;
    }

    @Property(name="lastName")
    @JsonIgnore
    public Optional<String> getLastName() {
        return Optional.ofNullable(lastName);
    }

    public DataSubject withLastName(String lastName) {
        DataSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSubject");
        _x.lastName = lastName;
        return _x;
    }

    @Property(name="residency")
    @JsonIgnore
    public Optional<String> getResidency() {
        return Optional.ofNullable(residency);
    }

    public DataSubject withResidency(String residency) {
        DataSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSubject");
        _x.residency = residency;
        return _x;
    }

    public DataSubject withUnmappedField(String name, Object value) {
        DataSubject _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String email;
        private String firstName;
        private String lastName;
        private String residency;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            this.changedFields = changedFields.add("firstName");
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            this.changedFields = changedFields.add("lastName");
            return this;
        }

        public Builder residency(String residency) {
            this.residency = residency;
            this.changedFields = changedFields.add("residency");
            return this;
        }

        public DataSubject build() {
            DataSubject _x = new DataSubject();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dataSubject";
            _x.email = email;
            _x.firstName = firstName;
            _x.lastName = lastName;
            _x.residency = residency;
            return _x;
        }
    }

    private DataSubject _copy() {
        DataSubject _x = new DataSubject();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.email = email;
        _x.firstName = firstName;
        _x.lastName = lastName;
        _x.residency = residency;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataSubject[");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("firstName=");
        b.append(this.firstName);
        b.append(", ");
        b.append("lastName=");
        b.append(this.lastName);
        b.append(", ");
        b.append("residency=");
        b.append(this.residency);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
