package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AccessPackageCustomExtensionHandlerStatus;
import odata.msgraph.client.beta.enums.AccessPackageCustomExtensionStage;

@JsonPropertyOrder({
    "@odata.type", 
    "customExtensionId", 
    "externalCorrelationId", 
    "stage", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CustomExtensionHandlerInstance implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("customExtensionId")
    protected String customExtensionId;

    @JsonProperty("externalCorrelationId")
    protected String externalCorrelationId;

    @JsonProperty("stage")
    protected AccessPackageCustomExtensionStage stage;

    @JsonProperty("status")
    protected AccessPackageCustomExtensionHandlerStatus status;

    protected CustomExtensionHandlerInstance() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customExtensionHandlerInstance";
    }

    @Property(name="customExtensionId")
    @JsonIgnore
    public Optional<String> getCustomExtensionId() {
        return Optional.ofNullable(customExtensionId);
    }

    public CustomExtensionHandlerInstance withCustomExtensionId(String customExtensionId) {
        CustomExtensionHandlerInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customExtensionHandlerInstance");
        _x.customExtensionId = customExtensionId;
        return _x;
    }

    @Property(name="externalCorrelationId")
    @JsonIgnore
    public Optional<String> getExternalCorrelationId() {
        return Optional.ofNullable(externalCorrelationId);
    }

    public CustomExtensionHandlerInstance withExternalCorrelationId(String externalCorrelationId) {
        CustomExtensionHandlerInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customExtensionHandlerInstance");
        _x.externalCorrelationId = externalCorrelationId;
        return _x;
    }

    @Property(name="stage")
    @JsonIgnore
    public Optional<AccessPackageCustomExtensionStage> getStage() {
        return Optional.ofNullable(stage);
    }

    public CustomExtensionHandlerInstance withStage(AccessPackageCustomExtensionStage stage) {
        CustomExtensionHandlerInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customExtensionHandlerInstance");
        _x.stage = stage;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AccessPackageCustomExtensionHandlerStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CustomExtensionHandlerInstance withStatus(AccessPackageCustomExtensionHandlerStatus status) {
        CustomExtensionHandlerInstance _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customExtensionHandlerInstance");
        _x.status = status;
        return _x;
    }

    public CustomExtensionHandlerInstance withUnmappedField(String name, Object value) {
        CustomExtensionHandlerInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String customExtensionId;
        private String externalCorrelationId;
        private AccessPackageCustomExtensionStage stage;
        private AccessPackageCustomExtensionHandlerStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customExtensionId(String customExtensionId) {
            this.customExtensionId = customExtensionId;
            this.changedFields = changedFields.add("customExtensionId");
            return this;
        }

        public Builder externalCorrelationId(String externalCorrelationId) {
            this.externalCorrelationId = externalCorrelationId;
            this.changedFields = changedFields.add("externalCorrelationId");
            return this;
        }

        public Builder stage(AccessPackageCustomExtensionStage stage) {
            this.stage = stage;
            this.changedFields = changedFields.add("stage");
            return this;
        }

        public Builder status(AccessPackageCustomExtensionHandlerStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CustomExtensionHandlerInstance build() {
            CustomExtensionHandlerInstance _x = new CustomExtensionHandlerInstance();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.customExtensionHandlerInstance";
            _x.customExtensionId = customExtensionId;
            _x.externalCorrelationId = externalCorrelationId;
            _x.stage = stage;
            _x.status = status;
            return _x;
        }
    }

    private CustomExtensionHandlerInstance _copy() {
        CustomExtensionHandlerInstance _x = new CustomExtensionHandlerInstance();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customExtensionId = customExtensionId;
        _x.externalCorrelationId = externalCorrelationId;
        _x.stage = stage;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomExtensionHandlerInstance[");
        b.append("customExtensionId=");
        b.append(this.customExtensionId);
        b.append(", ");
        b.append("externalCorrelationId=");
        b.append(this.externalCorrelationId);
        b.append(", ");
        b.append("stage=");
        b.append(this.stage);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
