package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationTransformConstant;
import odata.msgraph.client.beta.enums.DiffieHellmanGroup;
import odata.msgraph.client.beta.enums.PerfectForwardSecrecyGroup;
import odata.msgraph.client.beta.enums.VpnEncryptionAlgorithmType;
import odata.msgraph.client.beta.enums.VpnIntegrityAlgorithmType;


/**
 * <i>“VPN Security Association Parameters”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationTransformConstants", 
    "cipherTransformConstants", 
    "dhGroup", 
    "encryptionMethod", 
    "integrityCheckMethod", 
    "pfsGroup"})
@JsonInclude(Include.NON_NULL)
public class CryptographySuite implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationTransformConstants")
    protected AuthenticationTransformConstant authenticationTransformConstants;

    @JsonProperty("cipherTransformConstants")
    protected VpnEncryptionAlgorithmType cipherTransformConstants;

    @JsonProperty("dhGroup")
    protected DiffieHellmanGroup dhGroup;

    @JsonProperty("encryptionMethod")
    protected VpnEncryptionAlgorithmType encryptionMethod;

    @JsonProperty("integrityCheckMethod")
    protected VpnIntegrityAlgorithmType integrityCheckMethod;

    @JsonProperty("pfsGroup")
    protected PerfectForwardSecrecyGroup pfsGroup;

    protected CryptographySuite() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cryptographySuite";
    }

    /**
     * <i>“Authentication Transform Constants”</i>
     * 
     * @return property authenticationTransformConstants
     */
    @Property(name="authenticationTransformConstants")
    @JsonIgnore
    public Optional<AuthenticationTransformConstant> getAuthenticationTransformConstants() {
        return Optional.ofNullable(authenticationTransformConstants);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationTransformConstants} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Authentication Transform Constants”</i>
     * 
     * @param authenticationTransformConstants
     *            new value of {@code authenticationTransformConstants} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationTransformConstants} field changed
     */
    public CryptographySuite withAuthenticationTransformConstants(AuthenticationTransformConstant authenticationTransformConstants) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.authenticationTransformConstants = authenticationTransformConstants;
        return _x;
    }

    /**
     * <i>“Cipher Transform Constants”</i>
     * 
     * @return property cipherTransformConstants
     */
    @Property(name="cipherTransformConstants")
    @JsonIgnore
    public Optional<VpnEncryptionAlgorithmType> getCipherTransformConstants() {
        return Optional.ofNullable(cipherTransformConstants);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cipherTransformConstants} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Cipher Transform Constants”</i>
     * 
     * @param cipherTransformConstants
     *            new value of {@code cipherTransformConstants} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cipherTransformConstants} field changed
     */
    public CryptographySuite withCipherTransformConstants(VpnEncryptionAlgorithmType cipherTransformConstants) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.cipherTransformConstants = cipherTransformConstants;
        return _x;
    }

    /**
     * <i>“Diffie Hellman Group”</i>
     * 
     * @return property dhGroup
     */
    @Property(name="dhGroup")
    @JsonIgnore
    public Optional<DiffieHellmanGroup> getDhGroup() {
        return Optional.ofNullable(dhGroup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dhGroup} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Diffie Hellman Group”</i>
     * 
     * @param dhGroup
     *            new value of {@code dhGroup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dhGroup} field changed
     */
    public CryptographySuite withDhGroup(DiffieHellmanGroup dhGroup) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.dhGroup = dhGroup;
        return _x;
    }

    /**
     * <i>“Encryption Method”</i>
     * 
     * @return property encryptionMethod
     */
    @Property(name="encryptionMethod")
    @JsonIgnore
    public Optional<VpnEncryptionAlgorithmType> getEncryptionMethod() {
        return Optional.ofNullable(encryptionMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionMethod}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Encryption Method”</i>
     * 
     * @param encryptionMethod
     *            new value of {@code encryptionMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionMethod} field changed
     */
    public CryptographySuite withEncryptionMethod(VpnEncryptionAlgorithmType encryptionMethod) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.encryptionMethod = encryptionMethod;
        return _x;
    }

    /**
     * <i>“Integrity Check Method”</i>
     * 
     * @return property integrityCheckMethod
     */
    @Property(name="integrityCheckMethod")
    @JsonIgnore
    public Optional<VpnIntegrityAlgorithmType> getIntegrityCheckMethod() {
        return Optional.ofNullable(integrityCheckMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * integrityCheckMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Integrity Check Method”</i>
     * 
     * @param integrityCheckMethod
     *            new value of {@code integrityCheckMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code integrityCheckMethod} field changed
     */
    public CryptographySuite withIntegrityCheckMethod(VpnIntegrityAlgorithmType integrityCheckMethod) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.integrityCheckMethod = integrityCheckMethod;
        return _x;
    }

    /**
     * <i>“Perfect Forward Secrecy Group”</i>
     * 
     * @return property pfsGroup
     */
    @Property(name="pfsGroup")
    @JsonIgnore
    public Optional<PerfectForwardSecrecyGroup> getPfsGroup() {
        return Optional.ofNullable(pfsGroup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pfsGroup} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Perfect Forward Secrecy Group”</i>
     * 
     * @param pfsGroup
     *            new value of {@code pfsGroup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pfsGroup} field changed
     */
    public CryptographySuite withPfsGroup(PerfectForwardSecrecyGroup pfsGroup) {
        CryptographySuite _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cryptographySuite");
        _x.pfsGroup = pfsGroup;
        return _x;
    }

    public CryptographySuite withUnmappedField(String name, Object value) {
        CryptographySuite _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AuthenticationTransformConstant authenticationTransformConstants;
        private VpnEncryptionAlgorithmType cipherTransformConstants;
        private DiffieHellmanGroup dhGroup;
        private VpnEncryptionAlgorithmType encryptionMethod;
        private VpnIntegrityAlgorithmType integrityCheckMethod;
        private PerfectForwardSecrecyGroup pfsGroup;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Authentication Transform Constants”</i>
         * 
         * @param authenticationTransformConstants
         *            value of {@code authenticationTransformConstants} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationTransformConstants(AuthenticationTransformConstant authenticationTransformConstants) {
            this.authenticationTransformConstants = authenticationTransformConstants;
            this.changedFields = changedFields.add("authenticationTransformConstants");
            return this;
        }

        /**
         * <i>“Cipher Transform Constants”</i>
         * 
         * @param cipherTransformConstants
         *            value of {@code cipherTransformConstants} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cipherTransformConstants(VpnEncryptionAlgorithmType cipherTransformConstants) {
            this.cipherTransformConstants = cipherTransformConstants;
            this.changedFields = changedFields.add("cipherTransformConstants");
            return this;
        }

        /**
         * <i>“Diffie Hellman Group”</i>
         * 
         * @param dhGroup
         *            value of {@code dhGroup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dhGroup(DiffieHellmanGroup dhGroup) {
            this.dhGroup = dhGroup;
            this.changedFields = changedFields.add("dhGroup");
            return this;
        }

        /**
         * <i>“Encryption Method”</i>
         * 
         * @param encryptionMethod
         *            value of {@code encryptionMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionMethod(VpnEncryptionAlgorithmType encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            this.changedFields = changedFields.add("encryptionMethod");
            return this;
        }

        /**
         * <i>“Integrity Check Method”</i>
         * 
         * @param integrityCheckMethod
         *            value of {@code integrityCheckMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder integrityCheckMethod(VpnIntegrityAlgorithmType integrityCheckMethod) {
            this.integrityCheckMethod = integrityCheckMethod;
            this.changedFields = changedFields.add("integrityCheckMethod");
            return this;
        }

        /**
         * <i>“Perfect Forward Secrecy Group”</i>
         * 
         * @param pfsGroup
         *            value of {@code pfsGroup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pfsGroup(PerfectForwardSecrecyGroup pfsGroup) {
            this.pfsGroup = pfsGroup;
            this.changedFields = changedFields.add("pfsGroup");
            return this;
        }

        public CryptographySuite build() {
            CryptographySuite _x = new CryptographySuite();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cryptographySuite";
            _x.authenticationTransformConstants = authenticationTransformConstants;
            _x.cipherTransformConstants = cipherTransformConstants;
            _x.dhGroup = dhGroup;
            _x.encryptionMethod = encryptionMethod;
            _x.integrityCheckMethod = integrityCheckMethod;
            _x.pfsGroup = pfsGroup;
            return _x;
        }
    }

    private CryptographySuite _copy() {
        CryptographySuite _x = new CryptographySuite();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.authenticationTransformConstants = authenticationTransformConstants;
        _x.cipherTransformConstants = cipherTransformConstants;
        _x.dhGroup = dhGroup;
        _x.encryptionMethod = encryptionMethod;
        _x.integrityCheckMethod = integrityCheckMethod;
        _x.pfsGroup = pfsGroup;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CryptographySuite[");
        b.append("authenticationTransformConstants=");
        b.append(this.authenticationTransformConstants);
        b.append(", ");
        b.append("cipherTransformConstants=");
        b.append(this.cipherTransformConstants);
        b.append(", ");
        b.append("dhGroup=");
        b.append(this.dhGroup);
        b.append(", ");
        b.append("encryptionMethod=");
        b.append(this.encryptionMethod);
        b.append(", ");
        b.append("integrityCheckMethod=");
        b.append(this.integrityCheckMethod);
        b.append(", ");
        b.append("pfsGroup=");
        b.append(this.pfsGroup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
