package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CrossTenantAccessPolicyTargetConfigurationAccessType;

@JsonPropertyOrder({
    "@odata.type", 
    "accessType", 
    "targets"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyTargetConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessType")
    protected CrossTenantAccessPolicyTargetConfigurationAccessType accessType;

    @JsonProperty("targets")
    protected List<CrossTenantAccessPolicyTarget> targets;

    @JsonProperty("targets@nextLink")
    protected String targetsNextLink;

    protected CrossTenantAccessPolicyTargetConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyTargetConfiguration";
    }

    @Property(name="accessType")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyTargetConfigurationAccessType> getAccessType() {
        return Optional.ofNullable(accessType);
    }

    public CrossTenantAccessPolicyTargetConfiguration withAccessType(CrossTenantAccessPolicyTargetConfigurationAccessType accessType) {
        CrossTenantAccessPolicyTargetConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyTargetConfiguration");
        _x.accessType = accessType;
        return _x;
    }

    @Property(name="targets")
    @JsonIgnore
    public CollectionPage<CrossTenantAccessPolicyTarget> getTargets() {
        return new CollectionPage<CrossTenantAccessPolicyTarget>(contextPath, CrossTenantAccessPolicyTarget.class, this.targets, Optional.ofNullable(targetsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="targets")
    @JsonIgnore
    public CollectionPage<CrossTenantAccessPolicyTarget> getTargets(HttpRequestOptions options) {
        return new CollectionPage<CrossTenantAccessPolicyTarget>(contextPath, CrossTenantAccessPolicyTarget.class, this.targets, Optional.ofNullable(targetsNextLink), Collections.emptyList(), options);
    }

    public CrossTenantAccessPolicyTargetConfiguration withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyTargetConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CrossTenantAccessPolicyTargetConfigurationAccessType accessType;
        private List<CrossTenantAccessPolicyTarget> targets;
        private String targetsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessType(CrossTenantAccessPolicyTargetConfigurationAccessType accessType) {
            this.accessType = accessType;
            this.changedFields = changedFields.add("accessType");
            return this;
        }

        public Builder targets(List<CrossTenantAccessPolicyTarget> targets) {
            this.targets = targets;
            this.changedFields = changedFields.add("targets");
            return this;
        }

        public Builder targets(CrossTenantAccessPolicyTarget... targets) {
            return targets(Arrays.asList(targets));
        }

        public Builder targetsNextLink(String targetsNextLink) {
            this.targetsNextLink = targetsNextLink;
            this.changedFields = changedFields.add("targets");
            return this;
        }

        public CrossTenantAccessPolicyTargetConfiguration build() {
            CrossTenantAccessPolicyTargetConfiguration _x = new CrossTenantAccessPolicyTargetConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicyTargetConfiguration";
            _x.accessType = accessType;
            _x.targets = targets;
            _x.targetsNextLink = targetsNextLink;
            return _x;
        }
    }

    private CrossTenantAccessPolicyTargetConfiguration _copy() {
        CrossTenantAccessPolicyTargetConfiguration _x = new CrossTenantAccessPolicyTargetConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessType = accessType;
        _x.targets = targets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyTargetConfiguration[");
        b.append("accessType=");
        b.append(this.accessType);
        b.append(", ");
        b.append("targets=");
        b.append(this.targets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
