package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isCompliantDeviceAccepted", 
    "isHybridAzureADJoinedDeviceAccepted", 
    "isMfaAccepted"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyInboundTrust implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isCompliantDeviceAccepted")
    protected Boolean isCompliantDeviceAccepted;

    @JsonProperty("isHybridAzureADJoinedDeviceAccepted")
    protected Boolean isHybridAzureADJoinedDeviceAccepted;

    @JsonProperty("isMfaAccepted")
    protected Boolean isMfaAccepted;

    protected CrossTenantAccessPolicyInboundTrust() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyInboundTrust";
    }

    @Property(name="isCompliantDeviceAccepted")
    @JsonIgnore
    public Optional<Boolean> getIsCompliantDeviceAccepted() {
        return Optional.ofNullable(isCompliantDeviceAccepted);
    }

    public CrossTenantAccessPolicyInboundTrust withIsCompliantDeviceAccepted(Boolean isCompliantDeviceAccepted) {
        CrossTenantAccessPolicyInboundTrust _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyInboundTrust");
        _x.isCompliantDeviceAccepted = isCompliantDeviceAccepted;
        return _x;
    }

    @Property(name="isHybridAzureADJoinedDeviceAccepted")
    @JsonIgnore
    public Optional<Boolean> getIsHybridAzureADJoinedDeviceAccepted() {
        return Optional.ofNullable(isHybridAzureADJoinedDeviceAccepted);
    }

    public CrossTenantAccessPolicyInboundTrust withIsHybridAzureADJoinedDeviceAccepted(Boolean isHybridAzureADJoinedDeviceAccepted) {
        CrossTenantAccessPolicyInboundTrust _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyInboundTrust");
        _x.isHybridAzureADJoinedDeviceAccepted = isHybridAzureADJoinedDeviceAccepted;
        return _x;
    }

    @Property(name="isMfaAccepted")
    @JsonIgnore
    public Optional<Boolean> getIsMfaAccepted() {
        return Optional.ofNullable(isMfaAccepted);
    }

    public CrossTenantAccessPolicyInboundTrust withIsMfaAccepted(Boolean isMfaAccepted) {
        CrossTenantAccessPolicyInboundTrust _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyInboundTrust");
        _x.isMfaAccepted = isMfaAccepted;
        return _x;
    }

    public CrossTenantAccessPolicyInboundTrust withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyInboundTrust _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isCompliantDeviceAccepted;
        private Boolean isHybridAzureADJoinedDeviceAccepted;
        private Boolean isMfaAccepted;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isCompliantDeviceAccepted(Boolean isCompliantDeviceAccepted) {
            this.isCompliantDeviceAccepted = isCompliantDeviceAccepted;
            this.changedFields = changedFields.add("isCompliantDeviceAccepted");
            return this;
        }

        public Builder isHybridAzureADJoinedDeviceAccepted(Boolean isHybridAzureADJoinedDeviceAccepted) {
            this.isHybridAzureADJoinedDeviceAccepted = isHybridAzureADJoinedDeviceAccepted;
            this.changedFields = changedFields.add("isHybridAzureADJoinedDeviceAccepted");
            return this;
        }

        public Builder isMfaAccepted(Boolean isMfaAccepted) {
            this.isMfaAccepted = isMfaAccepted;
            this.changedFields = changedFields.add("isMfaAccepted");
            return this;
        }

        public CrossTenantAccessPolicyInboundTrust build() {
            CrossTenantAccessPolicyInboundTrust _x = new CrossTenantAccessPolicyInboundTrust();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicyInboundTrust";
            _x.isCompliantDeviceAccepted = isCompliantDeviceAccepted;
            _x.isHybridAzureADJoinedDeviceAccepted = isHybridAzureADJoinedDeviceAccepted;
            _x.isMfaAccepted = isMfaAccepted;
            return _x;
        }
    }

    private CrossTenantAccessPolicyInboundTrust _copy() {
        CrossTenantAccessPolicyInboundTrust _x = new CrossTenantAccessPolicyInboundTrust();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isCompliantDeviceAccepted = isCompliantDeviceAccepted;
        _x.isHybridAzureADJoinedDeviceAccepted = isHybridAzureADJoinedDeviceAccepted;
        _x.isMfaAccepted = isMfaAccepted;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyInboundTrust[");
        b.append("isCompliantDeviceAccepted=");
        b.append(this.isCompliantDeviceAccepted);
        b.append(", ");
        b.append("isHybridAzureADJoinedDeviceAccepted=");
        b.append(this.isHybridAzureADJoinedDeviceAccepted);
        b.append(", ");
        b.append("isMfaAccepted=");
        b.append(this.isMfaAccepted);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
