package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "conversationMemberRoles", 
    "conversationMemberUser", 
    "initiator"})
@JsonInclude(Include.NON_NULL)
public class ConversationMemberRoleUpdatedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("conversationMemberRoles")
    protected List<String> conversationMemberRoles;

    @JsonProperty("conversationMemberRoles@nextLink")
    protected String conversationMemberRolesNextLink;

    @JsonProperty("conversationMemberUser")
    protected TeamworkUserIdentity conversationMemberUser;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    protected ConversationMemberRoleUpdatedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conversationMemberRoleUpdatedEventMessageDetail";
    }

    @Property(name="conversationMemberRoles")
    @JsonIgnore
    public CollectionPage<String> getConversationMemberRoles() {
        return new CollectionPage<String>(contextPath, String.class, this.conversationMemberRoles, Optional.ofNullable(conversationMemberRolesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="conversationMemberRoles")
    @JsonIgnore
    public CollectionPage<String> getConversationMemberRoles(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.conversationMemberRoles, Optional.ofNullable(conversationMemberRolesNextLink), Collections.emptyList(), options);
    }

    @Property(name="conversationMemberUser")
    @JsonIgnore
    public Optional<TeamworkUserIdentity> getConversationMemberUser() {
        return Optional.ofNullable(conversationMemberUser);
    }

    public ConversationMemberRoleUpdatedEventMessageDetail withConversationMemberUser(TeamworkUserIdentity conversationMemberUser) {
        ConversationMemberRoleUpdatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversationMemberRoleUpdatedEventMessageDetail");
        _x.conversationMemberUser = conversationMemberUser;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public ConversationMemberRoleUpdatedEventMessageDetail withInitiator(IdentitySet initiator) {
        ConversationMemberRoleUpdatedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversationMemberRoleUpdatedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    public ConversationMemberRoleUpdatedEventMessageDetail withUnmappedField(String name, Object value) {
        ConversationMemberRoleUpdatedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConversationMemberRoleUpdatedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> conversationMemberRoles;
        private String conversationMemberRolesNextLink;
        private TeamworkUserIdentity conversationMemberUser;
        private IdentitySet initiator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder conversationMemberRoles(List<String> conversationMemberRoles) {
            this.conversationMemberRoles = conversationMemberRoles;
            this.changedFields = changedFields.add("conversationMemberRoles");
            return this;
        }

        public Builder conversationMemberRoles(String... conversationMemberRoles) {
            return conversationMemberRoles(Arrays.asList(conversationMemberRoles));
        }

        public Builder conversationMemberRolesNextLink(String conversationMemberRolesNextLink) {
            this.conversationMemberRolesNextLink = conversationMemberRolesNextLink;
            this.changedFields = changedFields.add("conversationMemberRoles");
            return this;
        }

        public Builder conversationMemberUser(TeamworkUserIdentity conversationMemberUser) {
            this.conversationMemberUser = conversationMemberUser;
            this.changedFields = changedFields.add("conversationMemberUser");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public ConversationMemberRoleUpdatedEventMessageDetail build() {
            ConversationMemberRoleUpdatedEventMessageDetail _x = new ConversationMemberRoleUpdatedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conversationMemberRoleUpdatedEventMessageDetail";
            _x.conversationMemberRoles = conversationMemberRoles;
            _x.conversationMemberRolesNextLink = conversationMemberRolesNextLink;
            _x.conversationMemberUser = conversationMemberUser;
            _x.initiator = initiator;
            return _x;
        }
    }

    private ConversationMemberRoleUpdatedEventMessageDetail _copy() {
        ConversationMemberRoleUpdatedEventMessageDetail _x = new ConversationMemberRoleUpdatedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conversationMemberRoles = conversationMemberRoles;
        _x.conversationMemberUser = conversationMemberUser;
        _x.initiator = initiator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConversationMemberRoleUpdatedEventMessageDetail[");
        b.append("conversationMemberRoles=");
        b.append(this.conversationMemberRoles);
        b.append(", ");
        b.append("conversationMemberUser=");
        b.append(this.conversationMemberUser);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
