package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "default", 
    "position"})
@JsonInclude(Include.NON_NULL)
public class ContentTypeOrder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("default")
    protected Boolean default_;

    @JsonProperty("position")
    protected Integer position;

    protected ContentTypeOrder() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contentTypeOrder";
    }

    @Property(name="default")
    @JsonIgnore
    public Optional<Boolean> getDefault() {
        return Optional.ofNullable(default_);
    }

    public ContentTypeOrder withDefault(Boolean default_) {
        ContentTypeOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentTypeOrder");
        _x.default_ = default_;
        return _x;
    }

    @Property(name="position")
    @JsonIgnore
    public Optional<Integer> getPosition() {
        return Optional.ofNullable(position);
    }

    public ContentTypeOrder withPosition(Integer position) {
        ContentTypeOrder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentTypeOrder");
        _x.position = position;
        return _x;
    }

    public ContentTypeOrder withUnmappedField(String name, Object value) {
        ContentTypeOrder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean default_;
        private Integer position;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder default_(Boolean default_) {
            this.default_ = default_;
            this.changedFields = changedFields.add("default");
            return this;
        }

        public Builder position(Integer position) {
            this.position = position;
            this.changedFields = changedFields.add("position");
            return this;
        }

        public ContentTypeOrder build() {
            ContentTypeOrder _x = new ContentTypeOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contentTypeOrder";
            _x.default_ = default_;
            _x.position = position;
            return _x;
        }
    }

    private ContentTypeOrder _copy() {
        ContentTypeOrder _x = new ContentTypeOrder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.default_ = default_;
        _x.position = position;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentTypeOrder[");
        b.append("default=");
        b.append(this.default_);
        b.append(", ");
        b.append("position=");
        b.append(this.position);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
