package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A ConfigManager policy summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "compliantDeviceCount", 
    "enforcedDeviceCount", 
    "failedDeviceCount", 
    "nonCompliantDeviceCount", 
    "pendingDeviceCount", 
    "targetedDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class ConfigManagerPolicySummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("compliantDeviceCount")
    protected Integer compliantDeviceCount;

    @JsonProperty("enforcedDeviceCount")
    protected Integer enforcedDeviceCount;

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    @JsonProperty("nonCompliantDeviceCount")
    protected Integer nonCompliantDeviceCount;

    @JsonProperty("pendingDeviceCount")
    protected Integer pendingDeviceCount;

    @JsonProperty("targetedDeviceCount")
    protected Integer targetedDeviceCount;

    protected ConfigManagerPolicySummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configManagerPolicySummary";
    }

    /**
     * <i>“The number of devices evaluated to be compliant by the policy.”</i>
     * 
     * @return property compliantDeviceCount
     */
    @Property(name="compliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getCompliantDeviceCount() {
        return Optional.ofNullable(compliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices evaluated to be compliant by the policy.”</i>
     * 
     * @param compliantDeviceCount
     *            new value of {@code compliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withCompliantDeviceCount(Integer compliantDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.compliantDeviceCount = compliantDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices that have have been remediated by the policy.”</i>
     * 
     * @return property enforcedDeviceCount
     */
    @Property(name="enforcedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getEnforcedDeviceCount() {
        return Optional.ofNullable(enforcedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforcedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices that have have been remediated by the policy.”</i>
     * 
     * @param enforcedDeviceCount
     *            new value of {@code enforcedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforcedDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withEnforcedDeviceCount(Integer enforcedDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.enforcedDeviceCount = enforcedDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices that failed to be evaluated by the policy.”</i>
     * 
     * @return property failedDeviceCount
     */
    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of devices that failed to be evaluated by the policy.”</i>
     * 
     * @param failedDeviceCount
     *            new value of {@code failedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withFailedDeviceCount(Integer failedDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices evaluated to be noncompliant by the policy.”</i>
     * 
     * @return property nonCompliantDeviceCount
     */
    @Property(name="nonCompliantDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNonCompliantDeviceCount() {
        return Optional.ofNullable(nonCompliantDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nonCompliantDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The number of devices evaluated to be noncompliant by the policy.”</i>
     * 
     * @param nonCompliantDeviceCount
     *            new value of {@code nonCompliantDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nonCompliantDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withNonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices that have acknowledged the policy but are pending
     * evaluation.”</i>
     * 
     * @return property pendingDeviceCount
     */
    @Property(name="pendingDeviceCount")
    @JsonIgnore
    public Optional<Integer> getPendingDeviceCount() {
        return Optional.ofNullable(pendingDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pendingDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices that have acknowledged the policy but are pending
     * evaluation.”</i>
     * 
     * @param pendingDeviceCount
     *            new value of {@code pendingDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pendingDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withPendingDeviceCount(Integer pendingDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.pendingDeviceCount = pendingDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of devices targeted by the policy.”</i>
     * 
     * @return property targetedDeviceCount
     */
    @Property(name="targetedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getTargetedDeviceCount() {
        return Optional.ofNullable(targetedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of devices targeted by the policy.”</i>
     * 
     * @param targetedDeviceCount
     *            new value of {@code targetedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedDeviceCount} field changed
     */
    public ConfigManagerPolicySummary withTargetedDeviceCount(Integer targetedDeviceCount) {
        ConfigManagerPolicySummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerPolicySummary");
        _x.targetedDeviceCount = targetedDeviceCount;
        return _x;
    }

    public ConfigManagerPolicySummary withUnmappedField(String name, Object value) {
        ConfigManagerPolicySummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer compliantDeviceCount;
        private Integer enforcedDeviceCount;
        private Integer failedDeviceCount;
        private Integer nonCompliantDeviceCount;
        private Integer pendingDeviceCount;
        private Integer targetedDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The number of devices evaluated to be compliant by the policy.”</i>
         * 
         * @param compliantDeviceCount
         *            value of {@code compliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantDeviceCount(Integer compliantDeviceCount) {
            this.compliantDeviceCount = compliantDeviceCount;
            this.changedFields = changedFields.add("compliantDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices that have have been remediated by the policy.”</i>
         * 
         * @param enforcedDeviceCount
         *            value of {@code enforcedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforcedDeviceCount(Integer enforcedDeviceCount) {
            this.enforcedDeviceCount = enforcedDeviceCount;
            this.changedFields = changedFields.add("enforcedDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices that failed to be evaluated by the policy.”</i>
         * 
         * @param failedDeviceCount
         *            value of {@code failedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices evaluated to be noncompliant by the policy.”</i>
         * 
         * @param nonCompliantDeviceCount
         *            value of {@code nonCompliantDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nonCompliantDeviceCount(Integer nonCompliantDeviceCount) {
            this.nonCompliantDeviceCount = nonCompliantDeviceCount;
            this.changedFields = changedFields.add("nonCompliantDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices that have acknowledged the policy but are pending
         * evaluation.”</i>
         * 
         * @param pendingDeviceCount
         *            value of {@code pendingDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pendingDeviceCount(Integer pendingDeviceCount) {
            this.pendingDeviceCount = pendingDeviceCount;
            this.changedFields = changedFields.add("pendingDeviceCount");
            return this;
        }

        /**
         * <i>“The number of devices targeted by the policy.”</i>
         * 
         * @param targetedDeviceCount
         *            value of {@code targetedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedDeviceCount(Integer targetedDeviceCount) {
            this.targetedDeviceCount = targetedDeviceCount;
            this.changedFields = changedFields.add("targetedDeviceCount");
            return this;
        }

        public ConfigManagerPolicySummary build() {
            ConfigManagerPolicySummary _x = new ConfigManagerPolicySummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.configManagerPolicySummary";
            _x.compliantDeviceCount = compliantDeviceCount;
            _x.enforcedDeviceCount = enforcedDeviceCount;
            _x.failedDeviceCount = failedDeviceCount;
            _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
            _x.pendingDeviceCount = pendingDeviceCount;
            _x.targetedDeviceCount = targetedDeviceCount;
            return _x;
        }
    }

    private ConfigManagerPolicySummary _copy() {
        ConfigManagerPolicySummary _x = new ConfigManagerPolicySummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.compliantDeviceCount = compliantDeviceCount;
        _x.enforcedDeviceCount = enforcedDeviceCount;
        _x.failedDeviceCount = failedDeviceCount;
        _x.nonCompliantDeviceCount = nonCompliantDeviceCount;
        _x.pendingDeviceCount = pendingDeviceCount;
        _x.targetedDeviceCount = targetedDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigManagerPolicySummary[");
        b.append("compliantDeviceCount=");
        b.append(this.compliantDeviceCount);
        b.append(", ");
        b.append("enforcedDeviceCount=");
        b.append(this.enforcedDeviceCount);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append(", ");
        b.append("nonCompliantDeviceCount=");
        b.append(this.nonCompliantDeviceCount);
        b.append(", ");
        b.append("pendingDeviceCount=");
        b.append(this.pendingDeviceCount);
        b.append(", ");
        b.append("targetedDeviceCount=");
        b.append(this.targetedDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
