package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FilterMode;

@JsonPropertyOrder({
    "@odata.type", 
    "mode", 
    "rule"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessFilter implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("mode")
    protected FilterMode mode;

    @JsonProperty("rule")
    protected String rule;

    protected ConditionalAccessFilter() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessFilter";
    }

    @Property(name="mode")
    @JsonIgnore
    public Optional<FilterMode> getMode() {
        return Optional.ofNullable(mode);
    }

    public ConditionalAccessFilter withMode(FilterMode mode) {
        ConditionalAccessFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessFilter");
        _x.mode = mode;
        return _x;
    }

    @Property(name="rule")
    @JsonIgnore
    public Optional<String> getRule() {
        return Optional.ofNullable(rule);
    }

    public ConditionalAccessFilter withRule(String rule) {
        ConditionalAccessFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessFilter");
        _x.rule = rule;
        return _x;
    }

    public ConditionalAccessFilter withUnmappedField(String name, Object value) {
        ConditionalAccessFilter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FilterMode mode;
        private String rule;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder mode(FilterMode mode) {
            this.mode = mode;
            this.changedFields = changedFields.add("mode");
            return this;
        }

        public Builder rule(String rule) {
            this.rule = rule;
            this.changedFields = changedFields.add("rule");
            return this;
        }

        public ConditionalAccessFilter build() {
            ConditionalAccessFilter _x = new ConditionalAccessFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessFilter";
            _x.mode = mode;
            _x.rule = rule;
            return _x;
        }
    }

    private ConditionalAccessFilter _copy() {
        ConditionalAccessFilter _x = new ConditionalAccessFilter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.mode = mode;
        _x.rule = rule;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessFilter[");
        b.append("mode=");
        b.append(this.mode);
        b.append(", ");
        b.append("rule=");
        b.append(this.rule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
