package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceFilter", 
    "excludeDevices", 
    "excludeDeviceStates", 
    "includeDevices", 
    "includeDeviceStates"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessDevices implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceFilter")
    protected ConditionalAccessFilter deviceFilter;

    @JsonProperty("excludeDevices")
    protected List<String> excludeDevices;

    @JsonProperty("excludeDevices@nextLink")
    protected String excludeDevicesNextLink;

    @JsonProperty("excludeDeviceStates")
    protected List<String> excludeDeviceStates;

    @JsonProperty("excludeDeviceStates@nextLink")
    protected String excludeDeviceStatesNextLink;

    @JsonProperty("includeDevices")
    protected List<String> includeDevices;

    @JsonProperty("includeDevices@nextLink")
    protected String includeDevicesNextLink;

    @JsonProperty("includeDeviceStates")
    protected List<String> includeDeviceStates;

    @JsonProperty("includeDeviceStates@nextLink")
    protected String includeDeviceStatesNextLink;

    protected ConditionalAccessDevices() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessDevices";
    }

    @Property(name="deviceFilter")
    @JsonIgnore
    public Optional<ConditionalAccessFilter> getDeviceFilter() {
        return Optional.ofNullable(deviceFilter);
    }

    public ConditionalAccessDevices withDeviceFilter(ConditionalAccessFilter deviceFilter) {
        ConditionalAccessDevices _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessDevices");
        _x.deviceFilter = deviceFilter;
        return _x;
    }

    @Property(name="excludeDevices")
    @JsonIgnore
    public CollectionPage<String> getExcludeDevices() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeDevices, Optional.ofNullable(excludeDevicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeDevices")
    @JsonIgnore
    public CollectionPage<String> getExcludeDevices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeDevices, Optional.ofNullable(excludeDevicesNextLink), Collections.emptyList(), options);
    }

    @Property(name="excludeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeDeviceStates() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeDeviceStates, Optional.ofNullable(excludeDeviceStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeDeviceStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeDeviceStates, Optional.ofNullable(excludeDeviceStatesNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeDevices")
    @JsonIgnore
    public CollectionPage<String> getIncludeDevices() {
        return new CollectionPage<String>(contextPath, String.class, this.includeDevices, Optional.ofNullable(includeDevicesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeDevices")
    @JsonIgnore
    public CollectionPage<String> getIncludeDevices(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeDevices, Optional.ofNullable(includeDevicesNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeDeviceStates() {
        return new CollectionPage<String>(contextPath, String.class, this.includeDeviceStates, Optional.ofNullable(includeDeviceStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeDeviceStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeDeviceStates, Optional.ofNullable(includeDeviceStatesNextLink), Collections.emptyList(), options);
    }

    public ConditionalAccessDevices withUnmappedField(String name, Object value) {
        ConditionalAccessDevices _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ConditionalAccessFilter deviceFilter;
        private List<String> excludeDevices;
        private String excludeDevicesNextLink;
        private List<String> excludeDeviceStates;
        private String excludeDeviceStatesNextLink;
        private List<String> includeDevices;
        private String includeDevicesNextLink;
        private List<String> includeDeviceStates;
        private String includeDeviceStatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder deviceFilter(ConditionalAccessFilter deviceFilter) {
            this.deviceFilter = deviceFilter;
            this.changedFields = changedFields.add("deviceFilter");
            return this;
        }

        public Builder excludeDevices(List<String> excludeDevices) {
            this.excludeDevices = excludeDevices;
            this.changedFields = changedFields.add("excludeDevices");
            return this;
        }

        public Builder excludeDevices(String... excludeDevices) {
            return excludeDevices(Arrays.asList(excludeDevices));
        }

        public Builder excludeDevicesNextLink(String excludeDevicesNextLink) {
            this.excludeDevicesNextLink = excludeDevicesNextLink;
            this.changedFields = changedFields.add("excludeDevices");
            return this;
        }

        public Builder excludeDeviceStates(List<String> excludeDeviceStates) {
            this.excludeDeviceStates = excludeDeviceStates;
            this.changedFields = changedFields.add("excludeDeviceStates");
            return this;
        }

        public Builder excludeDeviceStates(String... excludeDeviceStates) {
            return excludeDeviceStates(Arrays.asList(excludeDeviceStates));
        }

        public Builder excludeDeviceStatesNextLink(String excludeDeviceStatesNextLink) {
            this.excludeDeviceStatesNextLink = excludeDeviceStatesNextLink;
            this.changedFields = changedFields.add("excludeDeviceStates");
            return this;
        }

        public Builder includeDevices(List<String> includeDevices) {
            this.includeDevices = includeDevices;
            this.changedFields = changedFields.add("includeDevices");
            return this;
        }

        public Builder includeDevices(String... includeDevices) {
            return includeDevices(Arrays.asList(includeDevices));
        }

        public Builder includeDevicesNextLink(String includeDevicesNextLink) {
            this.includeDevicesNextLink = includeDevicesNextLink;
            this.changedFields = changedFields.add("includeDevices");
            return this;
        }

        public Builder includeDeviceStates(List<String> includeDeviceStates) {
            this.includeDeviceStates = includeDeviceStates;
            this.changedFields = changedFields.add("includeDeviceStates");
            return this;
        }

        public Builder includeDeviceStates(String... includeDeviceStates) {
            return includeDeviceStates(Arrays.asList(includeDeviceStates));
        }

        public Builder includeDeviceStatesNextLink(String includeDeviceStatesNextLink) {
            this.includeDeviceStatesNextLink = includeDeviceStatesNextLink;
            this.changedFields = changedFields.add("includeDeviceStates");
            return this;
        }

        public ConditionalAccessDevices build() {
            ConditionalAccessDevices _x = new ConditionalAccessDevices();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessDevices";
            _x.deviceFilter = deviceFilter;
            _x.excludeDevices = excludeDevices;
            _x.excludeDevicesNextLink = excludeDevicesNextLink;
            _x.excludeDeviceStates = excludeDeviceStates;
            _x.excludeDeviceStatesNextLink = excludeDeviceStatesNextLink;
            _x.includeDevices = includeDevices;
            _x.includeDevicesNextLink = includeDevicesNextLink;
            _x.includeDeviceStates = includeDeviceStates;
            _x.includeDeviceStatesNextLink = includeDeviceStatesNextLink;
            return _x;
        }
    }

    private ConditionalAccessDevices _copy() {
        ConditionalAccessDevices _x = new ConditionalAccessDevices();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.deviceFilter = deviceFilter;
        _x.excludeDevices = excludeDevices;
        _x.excludeDeviceStates = excludeDeviceStates;
        _x.includeDevices = includeDevices;
        _x.includeDeviceStates = includeDeviceStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessDevices[");
        b.append("deviceFilter=");
        b.append(this.deviceFilter);
        b.append(", ");
        b.append("excludeDevices=");
        b.append(this.excludeDevices);
        b.append(", ");
        b.append("excludeDeviceStates=");
        b.append(this.excludeDeviceStates);
        b.append(", ");
        b.append("includeDevices=");
        b.append(this.includeDevices);
        b.append(", ");
        b.append("includeDeviceStates=");
        b.append(this.includeDeviceStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
