package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "excludeStates", 
    "includeStates"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessDeviceStates implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("excludeStates")
    protected List<String> excludeStates;

    @JsonProperty("excludeStates@nextLink")
    protected String excludeStatesNextLink;

    @JsonProperty("includeStates")
    protected List<String> includeStates;

    @JsonProperty("includeStates@nextLink")
    protected String includeStatesNextLink;

    protected ConditionalAccessDeviceStates() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessDeviceStates";
    }

    @Property(name="excludeStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeStates() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeStates, Optional.ofNullable(excludeStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeStates, Optional.ofNullable(excludeStatesNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeStates() {
        return new CollectionPage<String>(contextPath, String.class, this.includeStates, Optional.ofNullable(includeStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeStates, Optional.ofNullable(includeStatesNextLink), Collections.emptyList(), options);
    }

    public ConditionalAccessDeviceStates withUnmappedField(String name, Object value) {
        ConditionalAccessDeviceStates _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> excludeStates;
        private String excludeStatesNextLink;
        private List<String> includeStates;
        private String includeStatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder excludeStates(List<String> excludeStates) {
            this.excludeStates = excludeStates;
            this.changedFields = changedFields.add("excludeStates");
            return this;
        }

        public Builder excludeStates(String... excludeStates) {
            return excludeStates(Arrays.asList(excludeStates));
        }

        public Builder excludeStatesNextLink(String excludeStatesNextLink) {
            this.excludeStatesNextLink = excludeStatesNextLink;
            this.changedFields = changedFields.add("excludeStates");
            return this;
        }

        public Builder includeStates(List<String> includeStates) {
            this.includeStates = includeStates;
            this.changedFields = changedFields.add("includeStates");
            return this;
        }

        public Builder includeStates(String... includeStates) {
            return includeStates(Arrays.asList(includeStates));
        }

        public Builder includeStatesNextLink(String includeStatesNextLink) {
            this.includeStatesNextLink = includeStatesNextLink;
            this.changedFields = changedFields.add("includeStates");
            return this;
        }

        public ConditionalAccessDeviceStates build() {
            ConditionalAccessDeviceStates _x = new ConditionalAccessDeviceStates();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessDeviceStates";
            _x.excludeStates = excludeStates;
            _x.excludeStatesNextLink = excludeStatesNextLink;
            _x.includeStates = includeStates;
            _x.includeStatesNextLink = includeStatesNextLink;
            return _x;
        }
    }

    private ConditionalAccessDeviceStates _copy() {
        ConditionalAccessDeviceStates _x = new ConditionalAccessDeviceStates();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.excludeStates = excludeStates;
        _x.includeStates = includeStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessDeviceStates[");
        b.append("excludeStates=");
        b.append(this.excludeStates);
        b.append(", ");
        b.append("includeStates=");
        b.append(this.includeStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
