package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "excludeServicePrincipals", 
    "includeServicePrincipals"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessClientApplications implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("excludeServicePrincipals")
    protected List<String> excludeServicePrincipals;

    @JsonProperty("excludeServicePrincipals@nextLink")
    protected String excludeServicePrincipalsNextLink;

    @JsonProperty("includeServicePrincipals")
    protected List<String> includeServicePrincipals;

    @JsonProperty("includeServicePrincipals@nextLink")
    protected String includeServicePrincipalsNextLink;

    protected ConditionalAccessClientApplications() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessClientApplications";
    }

    @Property(name="excludeServicePrincipals")
    @JsonIgnore
    public CollectionPage<String> getExcludeServicePrincipals() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeServicePrincipals, Optional.ofNullable(excludeServicePrincipalsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeServicePrincipals")
    @JsonIgnore
    public CollectionPage<String> getExcludeServicePrincipals(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeServicePrincipals, Optional.ofNullable(excludeServicePrincipalsNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeServicePrincipals")
    @JsonIgnore
    public CollectionPage<String> getIncludeServicePrincipals() {
        return new CollectionPage<String>(contextPath, String.class, this.includeServicePrincipals, Optional.ofNullable(includeServicePrincipalsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeServicePrincipals")
    @JsonIgnore
    public CollectionPage<String> getIncludeServicePrincipals(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeServicePrincipals, Optional.ofNullable(includeServicePrincipalsNextLink), Collections.emptyList(), options);
    }

    public ConditionalAccessClientApplications withUnmappedField(String name, Object value) {
        ConditionalAccessClientApplications _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> excludeServicePrincipals;
        private String excludeServicePrincipalsNextLink;
        private List<String> includeServicePrincipals;
        private String includeServicePrincipalsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder excludeServicePrincipals(List<String> excludeServicePrincipals) {
            this.excludeServicePrincipals = excludeServicePrincipals;
            this.changedFields = changedFields.add("excludeServicePrincipals");
            return this;
        }

        public Builder excludeServicePrincipals(String... excludeServicePrincipals) {
            return excludeServicePrincipals(Arrays.asList(excludeServicePrincipals));
        }

        public Builder excludeServicePrincipalsNextLink(String excludeServicePrincipalsNextLink) {
            this.excludeServicePrincipalsNextLink = excludeServicePrincipalsNextLink;
            this.changedFields = changedFields.add("excludeServicePrincipals");
            return this;
        }

        public Builder includeServicePrincipals(List<String> includeServicePrincipals) {
            this.includeServicePrincipals = includeServicePrincipals;
            this.changedFields = changedFields.add("includeServicePrincipals");
            return this;
        }

        public Builder includeServicePrincipals(String... includeServicePrincipals) {
            return includeServicePrincipals(Arrays.asList(includeServicePrincipals));
        }

        public Builder includeServicePrincipalsNextLink(String includeServicePrincipalsNextLink) {
            this.includeServicePrincipalsNextLink = includeServicePrincipalsNextLink;
            this.changedFields = changedFields.add("includeServicePrincipals");
            return this;
        }

        public ConditionalAccessClientApplications build() {
            ConditionalAccessClientApplications _x = new ConditionalAccessClientApplications();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessClientApplications";
            _x.excludeServicePrincipals = excludeServicePrincipals;
            _x.excludeServicePrincipalsNextLink = excludeServicePrincipalsNextLink;
            _x.includeServicePrincipals = includeServicePrincipals;
            _x.includeServicePrincipalsNextLink = includeServicePrincipalsNextLink;
            return _x;
        }
    }

    private ConditionalAccessClientApplications _copy() {
        ConditionalAccessClientApplications _x = new ConditionalAccessClientApplications();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.excludeServicePrincipals = excludeServicePrincipals;
        _x.includeServicePrincipals = includeServicePrincipals;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessClientApplications[");
        b.append("excludeServicePrincipals=");
        b.append(this.excludeServicePrincipals);
        b.append(", ");
        b.append("includeServicePrincipals=");
        b.append(this.includeServicePrincipals);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
