package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "excludeApplications", 
    "includeApplications", 
    "includeAuthenticationContextClassReferences", 
    "includeUserActions"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessApplications implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("excludeApplications")
    protected List<String> excludeApplications;

    @JsonProperty("excludeApplications@nextLink")
    protected String excludeApplicationsNextLink;

    @JsonProperty("includeApplications")
    protected List<String> includeApplications;

    @JsonProperty("includeApplications@nextLink")
    protected String includeApplicationsNextLink;

    @JsonProperty("includeAuthenticationContextClassReferences")
    protected List<String> includeAuthenticationContextClassReferences;

    @JsonProperty("includeAuthenticationContextClassReferences@nextLink")
    protected String includeAuthenticationContextClassReferencesNextLink;

    @JsonProperty("includeUserActions")
    protected List<String> includeUserActions;

    @JsonProperty("includeUserActions@nextLink")
    protected String includeUserActionsNextLink;

    protected ConditionalAccessApplications() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessApplications";
    }

    @Property(name="excludeApplications")
    @JsonIgnore
    public CollectionPage<String> getExcludeApplications() {
        return new CollectionPage<String>(contextPath, String.class, this.excludeApplications, Optional.ofNullable(excludeApplicationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeApplications")
    @JsonIgnore
    public CollectionPage<String> getExcludeApplications(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.excludeApplications, Optional.ofNullable(excludeApplicationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications() {
        return new CollectionPage<String>(contextPath, String.class, this.includeApplications, Optional.ofNullable(includeApplicationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeApplications, Optional.ofNullable(includeApplicationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeAuthenticationContextClassReferences")
    @JsonIgnore
    public CollectionPage<String> getIncludeAuthenticationContextClassReferences() {
        return new CollectionPage<String>(contextPath, String.class, this.includeAuthenticationContextClassReferences, Optional.ofNullable(includeAuthenticationContextClassReferencesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeAuthenticationContextClassReferences")
    @JsonIgnore
    public CollectionPage<String> getIncludeAuthenticationContextClassReferences(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeAuthenticationContextClassReferences, Optional.ofNullable(includeAuthenticationContextClassReferencesNextLink), Collections.emptyList(), options);
    }

    @Property(name="includeUserActions")
    @JsonIgnore
    public CollectionPage<String> getIncludeUserActions() {
        return new CollectionPage<String>(contextPath, String.class, this.includeUserActions, Optional.ofNullable(includeUserActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeUserActions")
    @JsonIgnore
    public CollectionPage<String> getIncludeUserActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.includeUserActions, Optional.ofNullable(includeUserActionsNextLink), Collections.emptyList(), options);
    }

    public ConditionalAccessApplications withUnmappedField(String name, Object value) {
        ConditionalAccessApplications _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> excludeApplications;
        private String excludeApplicationsNextLink;
        private List<String> includeApplications;
        private String includeApplicationsNextLink;
        private List<String> includeAuthenticationContextClassReferences;
        private String includeAuthenticationContextClassReferencesNextLink;
        private List<String> includeUserActions;
        private String includeUserActionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder excludeApplications(List<String> excludeApplications) {
            this.excludeApplications = excludeApplications;
            this.changedFields = changedFields.add("excludeApplications");
            return this;
        }

        public Builder excludeApplications(String... excludeApplications) {
            return excludeApplications(Arrays.asList(excludeApplications));
        }

        public Builder excludeApplicationsNextLink(String excludeApplicationsNextLink) {
            this.excludeApplicationsNextLink = excludeApplicationsNextLink;
            this.changedFields = changedFields.add("excludeApplications");
            return this;
        }

        public Builder includeApplications(List<String> includeApplications) {
            this.includeApplications = includeApplications;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public Builder includeApplications(String... includeApplications) {
            return includeApplications(Arrays.asList(includeApplications));
        }

        public Builder includeApplicationsNextLink(String includeApplicationsNextLink) {
            this.includeApplicationsNextLink = includeApplicationsNextLink;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public Builder includeAuthenticationContextClassReferences(List<String> includeAuthenticationContextClassReferences) {
            this.includeAuthenticationContextClassReferences = includeAuthenticationContextClassReferences;
            this.changedFields = changedFields.add("includeAuthenticationContextClassReferences");
            return this;
        }

        public Builder includeAuthenticationContextClassReferences(String... includeAuthenticationContextClassReferences) {
            return includeAuthenticationContextClassReferences(Arrays.asList(includeAuthenticationContextClassReferences));
        }

        public Builder includeAuthenticationContextClassReferencesNextLink(String includeAuthenticationContextClassReferencesNextLink) {
            this.includeAuthenticationContextClassReferencesNextLink = includeAuthenticationContextClassReferencesNextLink;
            this.changedFields = changedFields.add("includeAuthenticationContextClassReferences");
            return this;
        }

        public Builder includeUserActions(List<String> includeUserActions) {
            this.includeUserActions = includeUserActions;
            this.changedFields = changedFields.add("includeUserActions");
            return this;
        }

        public Builder includeUserActions(String... includeUserActions) {
            return includeUserActions(Arrays.asList(includeUserActions));
        }

        public Builder includeUserActionsNextLink(String includeUserActionsNextLink) {
            this.includeUserActionsNextLink = includeUserActionsNextLink;
            this.changedFields = changedFields.add("includeUserActions");
            return this;
        }

        public ConditionalAccessApplications build() {
            ConditionalAccessApplications _x = new ConditionalAccessApplications();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessApplications";
            _x.excludeApplications = excludeApplications;
            _x.excludeApplicationsNextLink = excludeApplicationsNextLink;
            _x.includeApplications = includeApplications;
            _x.includeApplicationsNextLink = includeApplicationsNextLink;
            _x.includeAuthenticationContextClassReferences = includeAuthenticationContextClassReferences;
            _x.includeAuthenticationContextClassReferencesNextLink = includeAuthenticationContextClassReferencesNextLink;
            _x.includeUserActions = includeUserActions;
            _x.includeUserActionsNextLink = includeUserActionsNextLink;
            return _x;
        }
    }

    private ConditionalAccessApplications _copy() {
        ConditionalAccessApplications _x = new ConditionalAccessApplications();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.excludeApplications = excludeApplications;
        _x.includeApplications = includeApplications;
        _x.includeAuthenticationContextClassReferences = includeAuthenticationContextClassReferences;
        _x.includeUserActions = includeUserActions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessApplications[");
        b.append("excludeApplications=");
        b.append(this.excludeApplications);
        b.append(", ");
        b.append("includeApplications=");
        b.append(this.includeApplications);
        b.append(", ");
        b.append("includeAuthenticationContextClassReferences=");
        b.append(this.includeAuthenticationContextClassReferences);
        b.append(", ");
        b.append("includeUserActions=");
        b.append(this.includeUserActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
