package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“User group targeting for Compliance Management Partner”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class ComplianceManagementPartnerAssignment implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    protected ComplianceManagementPartnerAssignment() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.complianceManagementPartnerAssignment";
    }

    /**
     * <i>“Group assignment target.”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Group assignment target.”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public ComplianceManagementPartnerAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        ComplianceManagementPartnerAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceManagementPartnerAssignment");
        _x.target = target;
        return _x;
    }

    public ComplianceManagementPartnerAssignment withUnmappedField(String name, Object value) {
        ComplianceManagementPartnerAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DeviceAndAppManagementAssignmentTarget target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Group assignment target.”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public ComplianceManagementPartnerAssignment build() {
            ComplianceManagementPartnerAssignment _x = new ComplianceManagementPartnerAssignment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.complianceManagementPartnerAssignment";
            _x.target = target;
            return _x;
        }
    }

    private ComplianceManagementPartnerAssignment _copy() {
        ComplianceManagementPartnerAssignment _x = new ComplianceManagementPartnerAssignment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplianceManagementPartnerAssignment[");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
