package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificationControls", 
    "certificationName"})
@JsonInclude(Include.NON_NULL)
public class ComplianceInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certificationControls")
    protected List<CertificationControl> certificationControls;

    @JsonProperty("certificationControls@nextLink")
    protected String certificationControlsNextLink;

    @JsonProperty("certificationName")
    protected String certificationName;

    protected ComplianceInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.complianceInformation";
    }

    @Property(name="certificationControls")
    @JsonIgnore
    public CollectionPage<CertificationControl> getCertificationControls() {
        return new CollectionPage<CertificationControl>(contextPath, CertificationControl.class, this.certificationControls, Optional.ofNullable(certificationControlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="certificationControls")
    @JsonIgnore
    public CollectionPage<CertificationControl> getCertificationControls(HttpRequestOptions options) {
        return new CollectionPage<CertificationControl>(contextPath, CertificationControl.class, this.certificationControls, Optional.ofNullable(certificationControlsNextLink), Collections.emptyList(), options);
    }

    @Property(name="certificationName")
    @JsonIgnore
    public Optional<String> getCertificationName() {
        return Optional.ofNullable(certificationName);
    }

    public ComplianceInformation withCertificationName(String certificationName) {
        ComplianceInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.complianceInformation");
        _x.certificationName = certificationName;
        return _x;
    }

    public ComplianceInformation withUnmappedField(String name, Object value) {
        ComplianceInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<CertificationControl> certificationControls;
        private String certificationControlsNextLink;
        private String certificationName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder certificationControls(List<CertificationControl> certificationControls) {
            this.certificationControls = certificationControls;
            this.changedFields = changedFields.add("certificationControls");
            return this;
        }

        public Builder certificationControls(CertificationControl... certificationControls) {
            return certificationControls(Arrays.asList(certificationControls));
        }

        public Builder certificationControlsNextLink(String certificationControlsNextLink) {
            this.certificationControlsNextLink = certificationControlsNextLink;
            this.changedFields = changedFields.add("certificationControls");
            return this;
        }

        public Builder certificationName(String certificationName) {
            this.certificationName = certificationName;
            this.changedFields = changedFields.add("certificationName");
            return this;
        }

        public ComplianceInformation build() {
            ComplianceInformation _x = new ComplianceInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.complianceInformation";
            _x.certificationControls = certificationControls;
            _x.certificationControlsNextLink = certificationControlsNextLink;
            _x.certificationName = certificationName;
            return _x;
        }
    }

    private ComplianceInformation _copy() {
        ComplianceInformation _x = new ComplianceInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certificationControls = certificationControls;
        _x.certificationName = certificationName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplianceInformation[");
        b.append("certificationControls=");
        b.append(this.certificationControls);
        b.append(", ");
        b.append("certificationName=");
        b.append(this.certificationName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
