package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class CommsNotifications implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("value")
    protected List<CommsNotification> value;

    @JsonProperty("value@nextLink")
    protected String valueNextLink;

    protected CommsNotifications() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.commsNotifications";
    }

    @Property(name="value")
    @JsonIgnore
    public CollectionPage<CommsNotification> getValue() {
        return new CollectionPage<CommsNotification>(contextPath, CommsNotification.class, this.value, Optional.ofNullable(valueNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="value")
    @JsonIgnore
    public CollectionPage<CommsNotification> getValue(HttpRequestOptions options) {
        return new CollectionPage<CommsNotification>(contextPath, CommsNotification.class, this.value, Optional.ofNullable(valueNextLink), Collections.emptyList(), options);
    }

    public CommsNotifications withUnmappedField(String name, Object value) {
        CommsNotifications _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<CommsNotification> value;
        private String valueNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder value(List<CommsNotification> value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder value(CommsNotification... value) {
            return value(Arrays.asList(value));
        }

        public Builder valueNextLink(String valueNextLink) {
            this.valueNextLink = valueNextLink;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public CommsNotifications build() {
            CommsNotifications _x = new CommsNotifications();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.commsNotifications";
            _x.value = value;
            _x.valueNextLink = valueNextLink;
            return _x;
        }
    }

    private CommsNotifications _copy() {
        CommsNotifications _x = new CommsNotifications();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommsNotifications[");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
