package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalInformation", 
    "code", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class CloudPcStatusDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("additionalInformation")
    protected List<KeyValuePair> additionalInformation;

    @JsonProperty("additionalInformation@nextLink")
    protected String additionalInformationNextLink;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("message")
    protected String message;

    protected CloudPcStatusDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcStatusDetails";
    }

    @Property(name="additionalInformation")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdditionalInformation() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.additionalInformation, Optional.ofNullable(additionalInformationNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="additionalInformation")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdditionalInformation(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.additionalInformation, Optional.ofNullable(additionalInformationNextLink), Collections.emptyList(), options);
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public CloudPcStatusDetails withCode(String code) {
        CloudPcStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcStatusDetails");
        _x.code = code;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public CloudPcStatusDetails withMessage(String message) {
        CloudPcStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcStatusDetails");
        _x.message = message;
        return _x;
    }

    public CloudPcStatusDetails withUnmappedField(String name, Object value) {
        CloudPcStatusDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<KeyValuePair> additionalInformation;
        private String additionalInformationNextLink;
        private String code;
        private String message;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder additionalInformation(List<KeyValuePair> additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder additionalInformation(KeyValuePair... additionalInformation) {
            return additionalInformation(Arrays.asList(additionalInformation));
        }

        public Builder additionalInformationNextLink(String additionalInformationNextLink) {
            this.additionalInformationNextLink = additionalInformationNextLink;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public CloudPcStatusDetails build() {
            CloudPcStatusDetails _x = new CloudPcStatusDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcStatusDetails";
            _x.additionalInformation = additionalInformation;
            _x.additionalInformationNextLink = additionalInformationNextLink;
            _x.code = code;
            _x.message = message;
            return _x;
        }
    }

    private CloudPcStatusDetails _copy() {
        CloudPcStatusDetails _x = new CloudPcStatusDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.additionalInformation = additionalInformation;
        _x.code = code;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcStatusDetails[");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
