package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "frequencyInHours", 
    "userRestoreEnabled"})
@JsonInclude(Include.NON_NULL)
public class CloudPcRestorePointSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("frequencyInHours")
    protected Integer frequencyInHours;

    @JsonProperty("userRestoreEnabled")
    protected Boolean userRestoreEnabled;

    protected CloudPcRestorePointSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcRestorePointSetting";
    }

    @Property(name="frequencyInHours")
    @JsonIgnore
    public Optional<Integer> getFrequencyInHours() {
        return Optional.ofNullable(frequencyInHours);
    }

    public CloudPcRestorePointSetting withFrequencyInHours(Integer frequencyInHours) {
        CloudPcRestorePointSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRestorePointSetting");
        _x.frequencyInHours = frequencyInHours;
        return _x;
    }

    @Property(name="userRestoreEnabled")
    @JsonIgnore
    public Optional<Boolean> getUserRestoreEnabled() {
        return Optional.ofNullable(userRestoreEnabled);
    }

    public CloudPcRestorePointSetting withUserRestoreEnabled(Boolean userRestoreEnabled) {
        CloudPcRestorePointSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcRestorePointSetting");
        _x.userRestoreEnabled = userRestoreEnabled;
        return _x;
    }

    public CloudPcRestorePointSetting withUnmappedField(String name, Object value) {
        CloudPcRestorePointSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer frequencyInHours;
        private Boolean userRestoreEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder frequencyInHours(Integer frequencyInHours) {
            this.frequencyInHours = frequencyInHours;
            this.changedFields = changedFields.add("frequencyInHours");
            return this;
        }

        public Builder userRestoreEnabled(Boolean userRestoreEnabled) {
            this.userRestoreEnabled = userRestoreEnabled;
            this.changedFields = changedFields.add("userRestoreEnabled");
            return this;
        }

        public CloudPcRestorePointSetting build() {
            CloudPcRestorePointSetting _x = new CloudPcRestorePointSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcRestorePointSetting";
            _x.frequencyInHours = frequencyInHours;
            _x.userRestoreEnabled = userRestoreEnabled;
            return _x;
        }
    }

    private CloudPcRestorePointSetting _copy() {
        CloudPcRestorePointSetting _x = new CloudPcRestorePointSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.frequencyInHours = frequencyInHours;
        _x.userRestoreEnabled = userRestoreEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcRestorePointSetting[");
        b.append("frequencyInHours=");
        b.append(this.frequencyInHours);
        b.append(", ");
        b.append("userRestoreEnabled=");
        b.append(this.userRestoreEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
