package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "healthChecks", 
    "startDateTime"})
@JsonInclude(Include.NON_NULL)
public class CloudPcOnPremisesConnectionStatusDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("healthChecks")
    protected List<CloudPcOnPremisesConnectionHealthCheck> healthChecks;

    @JsonProperty("healthChecks@nextLink")
    protected String healthChecksNextLink;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    protected CloudPcOnPremisesConnectionStatusDetails() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcOnPremisesConnectionStatusDetails";
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public CloudPcOnPremisesConnectionStatusDetails withEndDateTime(OffsetDateTime endDateTime) {
        CloudPcOnPremisesConnectionStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionStatusDetails");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="healthChecks")
    @JsonIgnore
    public CollectionPage<CloudPcOnPremisesConnectionHealthCheck> getHealthChecks() {
        return new CollectionPage<CloudPcOnPremisesConnectionHealthCheck>(contextPath, CloudPcOnPremisesConnectionHealthCheck.class, this.healthChecks, Optional.ofNullable(healthChecksNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="healthChecks")
    @JsonIgnore
    public CollectionPage<CloudPcOnPremisesConnectionHealthCheck> getHealthChecks(HttpRequestOptions options) {
        return new CollectionPage<CloudPcOnPremisesConnectionHealthCheck>(contextPath, CloudPcOnPremisesConnectionHealthCheck.class, this.healthChecks, Optional.ofNullable(healthChecksNextLink), Collections.emptyList(), options);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public CloudPcOnPremisesConnectionStatusDetails withStartDateTime(OffsetDateTime startDateTime) {
        CloudPcOnPremisesConnectionStatusDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionStatusDetails");
        _x.startDateTime = startDateTime;
        return _x;
    }

    public CloudPcOnPremisesConnectionStatusDetails withUnmappedField(String name, Object value) {
        CloudPcOnPremisesConnectionStatusDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime endDateTime;
        private List<CloudPcOnPremisesConnectionHealthCheck> healthChecks;
        private String healthChecksNextLink;
        private OffsetDateTime startDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder healthChecks(List<CloudPcOnPremisesConnectionHealthCheck> healthChecks) {
            this.healthChecks = healthChecks;
            this.changedFields = changedFields.add("healthChecks");
            return this;
        }

        public Builder healthChecks(CloudPcOnPremisesConnectionHealthCheck... healthChecks) {
            return healthChecks(Arrays.asList(healthChecks));
        }

        public Builder healthChecksNextLink(String healthChecksNextLink) {
            this.healthChecksNextLink = healthChecksNextLink;
            this.changedFields = changedFields.add("healthChecks");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public CloudPcOnPremisesConnectionStatusDetails build() {
            CloudPcOnPremisesConnectionStatusDetails _x = new CloudPcOnPremisesConnectionStatusDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcOnPremisesConnectionStatusDetails";
            _x.endDateTime = endDateTime;
            _x.healthChecks = healthChecks;
            _x.healthChecksNextLink = healthChecksNextLink;
            _x.startDateTime = startDateTime;
            return _x;
        }
    }

    private CloudPcOnPremisesConnectionStatusDetails _copy() {
        CloudPcOnPremisesConnectionStatusDetails _x = new CloudPcOnPremisesConnectionStatusDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.endDateTime = endDateTime;
        _x.healthChecks = healthChecks;
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcOnPremisesConnectionStatusDetails[");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("healthChecks=");
        b.append(this.healthChecks);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
