package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcOnPremisesConnectionHealthCheckErrorType;
import odata.msgraph.client.beta.enums.CloudPcOnPremisesConnectionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "additionalDetails", 
    "displayName", 
    "endDateTime", 
    "errorType", 
    "recommendedAction", 
    "startDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CloudPcOnPremisesConnectionHealthCheck implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("additionalDetails")
    protected String additionalDetails;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("errorType")
    protected CloudPcOnPremisesConnectionHealthCheckErrorType errorType;

    @JsonProperty("recommendedAction")
    protected String recommendedAction;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("status")
    protected CloudPcOnPremisesConnectionStatus status;

    protected CloudPcOnPremisesConnectionHealthCheck() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck";
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public Optional<String> getAdditionalDetails() {
        return Optional.ofNullable(additionalDetails);
    }

    public CloudPcOnPremisesConnectionHealthCheck withAdditionalDetails(String additionalDetails) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcOnPremisesConnectionHealthCheck withDisplayName(String displayName) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public CloudPcOnPremisesConnectionHealthCheck withEndDateTime(OffsetDateTime endDateTime) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="errorType")
    @JsonIgnore
    public Optional<CloudPcOnPremisesConnectionHealthCheckErrorType> getErrorType() {
        return Optional.ofNullable(errorType);
    }

    public CloudPcOnPremisesConnectionHealthCheck withErrorType(CloudPcOnPremisesConnectionHealthCheckErrorType errorType) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.errorType = errorType;
        return _x;
    }

    @Property(name="recommendedAction")
    @JsonIgnore
    public Optional<String> getRecommendedAction() {
        return Optional.ofNullable(recommendedAction);
    }

    public CloudPcOnPremisesConnectionHealthCheck withRecommendedAction(String recommendedAction) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.recommendedAction = recommendedAction;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public CloudPcOnPremisesConnectionHealthCheck withStartDateTime(OffsetDateTime startDateTime) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CloudPcOnPremisesConnectionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CloudPcOnPremisesConnectionHealthCheck withStatus(CloudPcOnPremisesConnectionStatus status) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck");
        _x.status = status;
        return _x;
    }

    public CloudPcOnPremisesConnectionHealthCheck withUnmappedField(String name, Object value) {
        CloudPcOnPremisesConnectionHealthCheck _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String additionalDetails;
        private String displayName;
        private OffsetDateTime endDateTime;
        private CloudPcOnPremisesConnectionHealthCheckErrorType errorType;
        private String recommendedAction;
        private OffsetDateTime startDateTime;
        private CloudPcOnPremisesConnectionStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder errorType(CloudPcOnPremisesConnectionHealthCheckErrorType errorType) {
            this.errorType = errorType;
            this.changedFields = changedFields.add("errorType");
            return this;
        }

        public Builder recommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
            this.changedFields = changedFields.add("recommendedAction");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(CloudPcOnPremisesConnectionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CloudPcOnPremisesConnectionHealthCheck build() {
            CloudPcOnPremisesConnectionHealthCheck _x = new CloudPcOnPremisesConnectionHealthCheck();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcOnPremisesConnectionHealthCheck";
            _x.additionalDetails = additionalDetails;
            _x.displayName = displayName;
            _x.endDateTime = endDateTime;
            _x.errorType = errorType;
            _x.recommendedAction = recommendedAction;
            _x.startDateTime = startDateTime;
            _x.status = status;
            return _x;
        }
    }

    private CloudPcOnPremisesConnectionHealthCheck _copy() {
        CloudPcOnPremisesConnectionHealthCheck _x = new CloudPcOnPremisesConnectionHealthCheck();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.additionalDetails = additionalDetails;
        _x.displayName = displayName;
        _x.endDateTime = endDateTime;
        _x.errorType = errorType;
        _x.recommendedAction = recommendedAction;
        _x.startDateTime = startDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcOnPremisesConnectionHealthCheck[");
        b.append("additionalDetails=");
        b.append(this.additionalDetails);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("errorType=");
        b.append(this.errorType);
        b.append(", ");
        b.append("recommendedAction=");
        b.append(this.recommendedAction);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
