package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "groupId"})
@JsonInclude(Include.NON_NULL)
public class CloudPcManagementGroupAssignmentTarget extends CloudPcManagementAssignmentTarget implements ODataType {

    @JsonProperty("groupId")
    protected String groupId;

    protected CloudPcManagementGroupAssignmentTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcManagementGroupAssignmentTarget";
    }

    @Property(name="groupId")
    @JsonIgnore
    public Optional<String> getGroupId() {
        return Optional.ofNullable(groupId);
    }

    public CloudPcManagementGroupAssignmentTarget withGroupId(String groupId) {
        CloudPcManagementGroupAssignmentTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcManagementGroupAssignmentTarget");
        _x.groupId = groupId;
        return _x;
    }

    public CloudPcManagementGroupAssignmentTarget withUnmappedField(String name, Object value) {
        CloudPcManagementGroupAssignmentTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcManagementGroupAssignmentTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String groupId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.changedFields = changedFields.add("groupId");
            return this;
        }

        public CloudPcManagementGroupAssignmentTarget build() {
            CloudPcManagementGroupAssignmentTarget _x = new CloudPcManagementGroupAssignmentTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcManagementGroupAssignmentTarget";
            _x.groupId = groupId;
            return _x;
        }
    }

    private CloudPcManagementGroupAssignmentTarget _copy() {
        CloudPcManagementGroupAssignmentTarget _x = new CloudPcManagementGroupAssignmentTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.groupId = groupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcManagementGroupAssignmentTarget[");
        b.append("groupId=");
        b.append(this.groupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
