package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "failedDeviceIds", 
    "notFoundDeviceIds", 
    "notSupportedDeviceIds", 
    "successfulDeviceIds"})
@JsonInclude(Include.NON_NULL)
public class CloudPcBulkRemoteActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("failedDeviceIds")
    protected List<String> failedDeviceIds;

    @JsonProperty("failedDeviceIds@nextLink")
    protected String failedDeviceIdsNextLink;

    @JsonProperty("notFoundDeviceIds")
    protected List<String> notFoundDeviceIds;

    @JsonProperty("notFoundDeviceIds@nextLink")
    protected String notFoundDeviceIdsNextLink;

    @JsonProperty("notSupportedDeviceIds")
    protected List<String> notSupportedDeviceIds;

    @JsonProperty("notSupportedDeviceIds@nextLink")
    protected String notSupportedDeviceIdsNextLink;

    @JsonProperty("successfulDeviceIds")
    protected List<String> successfulDeviceIds;

    @JsonProperty("successfulDeviceIds@nextLink")
    protected String successfulDeviceIdsNextLink;

    protected CloudPcBulkRemoteActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcBulkRemoteActionResult";
    }

    @Property(name="failedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, this.failedDeviceIds, Optional.ofNullable(failedDeviceIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="failedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.failedDeviceIds, Optional.ofNullable(failedDeviceIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="notFoundDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, this.notFoundDeviceIds, Optional.ofNullable(notFoundDeviceIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="notFoundDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.notFoundDeviceIds, Optional.ofNullable(notFoundDeviceIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="notSupportedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotSupportedDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, this.notSupportedDeviceIds, Optional.ofNullable(notSupportedDeviceIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="notSupportedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotSupportedDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.notSupportedDeviceIds, Optional.ofNullable(notSupportedDeviceIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="successfulDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, this.successfulDeviceIds, Optional.ofNullable(successfulDeviceIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="successfulDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.successfulDeviceIds, Optional.ofNullable(successfulDeviceIdsNextLink), Collections.emptyList(), options);
    }

    public CloudPcBulkRemoteActionResult withUnmappedField(String name, Object value) {
        CloudPcBulkRemoteActionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> failedDeviceIds;
        private String failedDeviceIdsNextLink;
        private List<String> notFoundDeviceIds;
        private String notFoundDeviceIdsNextLink;
        private List<String> notSupportedDeviceIds;
        private String notSupportedDeviceIdsNextLink;
        private List<String> successfulDeviceIds;
        private String successfulDeviceIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder failedDeviceIds(List<String> failedDeviceIds) {
            this.failedDeviceIds = failedDeviceIds;
            this.changedFields = changedFields.add("failedDeviceIds");
            return this;
        }

        public Builder failedDeviceIds(String... failedDeviceIds) {
            return failedDeviceIds(Arrays.asList(failedDeviceIds));
        }

        public Builder failedDeviceIdsNextLink(String failedDeviceIdsNextLink) {
            this.failedDeviceIdsNextLink = failedDeviceIdsNextLink;
            this.changedFields = changedFields.add("failedDeviceIds");
            return this;
        }

        public Builder notFoundDeviceIds(List<String> notFoundDeviceIds) {
            this.notFoundDeviceIds = notFoundDeviceIds;
            this.changedFields = changedFields.add("notFoundDeviceIds");
            return this;
        }

        public Builder notFoundDeviceIds(String... notFoundDeviceIds) {
            return notFoundDeviceIds(Arrays.asList(notFoundDeviceIds));
        }

        public Builder notFoundDeviceIdsNextLink(String notFoundDeviceIdsNextLink) {
            this.notFoundDeviceIdsNextLink = notFoundDeviceIdsNextLink;
            this.changedFields = changedFields.add("notFoundDeviceIds");
            return this;
        }

        public Builder notSupportedDeviceIds(List<String> notSupportedDeviceIds) {
            this.notSupportedDeviceIds = notSupportedDeviceIds;
            this.changedFields = changedFields.add("notSupportedDeviceIds");
            return this;
        }

        public Builder notSupportedDeviceIds(String... notSupportedDeviceIds) {
            return notSupportedDeviceIds(Arrays.asList(notSupportedDeviceIds));
        }

        public Builder notSupportedDeviceIdsNextLink(String notSupportedDeviceIdsNextLink) {
            this.notSupportedDeviceIdsNextLink = notSupportedDeviceIdsNextLink;
            this.changedFields = changedFields.add("notSupportedDeviceIds");
            return this;
        }

        public Builder successfulDeviceIds(List<String> successfulDeviceIds) {
            this.successfulDeviceIds = successfulDeviceIds;
            this.changedFields = changedFields.add("successfulDeviceIds");
            return this;
        }

        public Builder successfulDeviceIds(String... successfulDeviceIds) {
            return successfulDeviceIds(Arrays.asList(successfulDeviceIds));
        }

        public Builder successfulDeviceIdsNextLink(String successfulDeviceIdsNextLink) {
            this.successfulDeviceIdsNextLink = successfulDeviceIdsNextLink;
            this.changedFields = changedFields.add("successfulDeviceIds");
            return this;
        }

        public CloudPcBulkRemoteActionResult build() {
            CloudPcBulkRemoteActionResult _x = new CloudPcBulkRemoteActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcBulkRemoteActionResult";
            _x.failedDeviceIds = failedDeviceIds;
            _x.failedDeviceIdsNextLink = failedDeviceIdsNextLink;
            _x.notFoundDeviceIds = notFoundDeviceIds;
            _x.notFoundDeviceIdsNextLink = notFoundDeviceIdsNextLink;
            _x.notSupportedDeviceIds = notSupportedDeviceIds;
            _x.notSupportedDeviceIdsNextLink = notSupportedDeviceIdsNextLink;
            _x.successfulDeviceIds = successfulDeviceIds;
            _x.successfulDeviceIdsNextLink = successfulDeviceIdsNextLink;
            return _x;
        }
    }

    private CloudPcBulkRemoteActionResult _copy() {
        CloudPcBulkRemoteActionResult _x = new CloudPcBulkRemoteActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.failedDeviceIds = failedDeviceIds;
        _x.notFoundDeviceIds = notFoundDeviceIds;
        _x.notSupportedDeviceIds = notSupportedDeviceIds;
        _x.successfulDeviceIds = successfulDeviceIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcBulkRemoteActionResult[");
        b.append("failedDeviceIds=");
        b.append(this.failedDeviceIds);
        b.append(", ");
        b.append("notFoundDeviceIds=");
        b.append(this.notFoundDeviceIds);
        b.append(", ");
        b.append("notSupportedDeviceIds=");
        b.append(this.notSupportedDeviceIds);
        b.append(", ");
        b.append("successfulDeviceIds=");
        b.append(this.successfulDeviceIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
