package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcAuditActorType;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationDisplayName", 
    "applicationId", 
    "ipAddress", 
    "remoteTenantId", 
    "remoteUserId", 
    "servicePrincipalName", 
    "type", 
    "userId", 
    "userPermissions", 
    "userPrincipalName", 
    "userRoleScopeTags"})
@JsonInclude(Include.NON_NULL)
public class CloudPcAuditActor implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationDisplayName")
    protected String applicationDisplayName;

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("ipAddress")
    protected String ipAddress;

    @JsonProperty("remoteTenantId")
    protected String remoteTenantId;

    @JsonProperty("remoteUserId")
    protected String remoteUserId;

    @JsonProperty("servicePrincipalName")
    protected String servicePrincipalName;

    @JsonProperty("type")
    protected CloudPcAuditActorType type;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPermissions")
    protected List<String> userPermissions;

    @JsonProperty("userPermissions@nextLink")
    protected String userPermissionsNextLink;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("userRoleScopeTags")
    protected List<CloudPcUserRoleScopeTagInfo> userRoleScopeTags;

    @JsonProperty("userRoleScopeTags@nextLink")
    protected String userRoleScopeTagsNextLink;

    protected CloudPcAuditActor() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcAuditActor";
    }

    @Property(name="applicationDisplayName")
    @JsonIgnore
    public Optional<String> getApplicationDisplayName() {
        return Optional.ofNullable(applicationDisplayName);
    }

    public CloudPcAuditActor withApplicationDisplayName(String applicationDisplayName) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.applicationDisplayName = applicationDisplayName;
        return _x;
    }

    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    public CloudPcAuditActor withApplicationId(String applicationId) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.applicationId = applicationId;
        return _x;
    }

    @Property(name="ipAddress")
    @JsonIgnore
    public Optional<String> getIpAddress() {
        return Optional.ofNullable(ipAddress);
    }

    public CloudPcAuditActor withIpAddress(String ipAddress) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.ipAddress = ipAddress;
        return _x;
    }

    @Property(name="remoteTenantId")
    @JsonIgnore
    public Optional<String> getRemoteTenantId() {
        return Optional.ofNullable(remoteTenantId);
    }

    public CloudPcAuditActor withRemoteTenantId(String remoteTenantId) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.remoteTenantId = remoteTenantId;
        return _x;
    }

    @Property(name="remoteUserId")
    @JsonIgnore
    public Optional<String> getRemoteUserId() {
        return Optional.ofNullable(remoteUserId);
    }

    public CloudPcAuditActor withRemoteUserId(String remoteUserId) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.remoteUserId = remoteUserId;
        return _x;
    }

    @Property(name="servicePrincipalName")
    @JsonIgnore
    public Optional<String> getServicePrincipalName() {
        return Optional.ofNullable(servicePrincipalName);
    }

    public CloudPcAuditActor withServicePrincipalName(String servicePrincipalName) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.servicePrincipalName = servicePrincipalName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<CloudPcAuditActorType> getType() {
        return Optional.ofNullable(type);
    }

    public CloudPcAuditActor withType(CloudPcAuditActorType type) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.type = type;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public CloudPcAuditActor withUserId(String userId) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPermissions")
    @JsonIgnore
    public CollectionPage<String> getUserPermissions() {
        return new CollectionPage<String>(contextPath, String.class, this.userPermissions, Optional.ofNullable(userPermissionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userPermissions")
    @JsonIgnore
    public CollectionPage<String> getUserPermissions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.userPermissions, Optional.ofNullable(userPermissionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public CloudPcAuditActor withUserPrincipalName(String userPrincipalName) {
        CloudPcAuditActor _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditActor");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="userRoleScopeTags")
    @JsonIgnore
    public CollectionPage<CloudPcUserRoleScopeTagInfo> getUserRoleScopeTags() {
        return new CollectionPage<CloudPcUserRoleScopeTagInfo>(contextPath, CloudPcUserRoleScopeTagInfo.class, this.userRoleScopeTags, Optional.ofNullable(userRoleScopeTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userRoleScopeTags")
    @JsonIgnore
    public CollectionPage<CloudPcUserRoleScopeTagInfo> getUserRoleScopeTags(HttpRequestOptions options) {
        return new CollectionPage<CloudPcUserRoleScopeTagInfo>(contextPath, CloudPcUserRoleScopeTagInfo.class, this.userRoleScopeTags, Optional.ofNullable(userRoleScopeTagsNextLink), Collections.emptyList(), options);
    }

    public CloudPcAuditActor withUnmappedField(String name, Object value) {
        CloudPcAuditActor _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationDisplayName;
        private String applicationId;
        private String ipAddress;
        private String remoteTenantId;
        private String remoteUserId;
        private String servicePrincipalName;
        private CloudPcAuditActorType type;
        private String userId;
        private List<String> userPermissions;
        private String userPermissionsNextLink;
        private String userPrincipalName;
        private List<CloudPcUserRoleScopeTagInfo> userRoleScopeTags;
        private String userRoleScopeTagsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applicationDisplayName(String applicationDisplayName) {
            this.applicationDisplayName = applicationDisplayName;
            this.changedFields = changedFields.add("applicationDisplayName");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder remoteTenantId(String remoteTenantId) {
            this.remoteTenantId = remoteTenantId;
            this.changedFields = changedFields.add("remoteTenantId");
            return this;
        }

        public Builder remoteUserId(String remoteUserId) {
            this.remoteUserId = remoteUserId;
            this.changedFields = changedFields.add("remoteUserId");
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.changedFields = changedFields.add("servicePrincipalName");
            return this;
        }

        public Builder type(CloudPcAuditActorType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPermissions(List<String> userPermissions) {
            this.userPermissions = userPermissions;
            this.changedFields = changedFields.add("userPermissions");
            return this;
        }

        public Builder userPermissions(String... userPermissions) {
            return userPermissions(Arrays.asList(userPermissions));
        }

        public Builder userPermissionsNextLink(String userPermissionsNextLink) {
            this.userPermissionsNextLink = userPermissionsNextLink;
            this.changedFields = changedFields.add("userPermissions");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder userRoleScopeTags(List<CloudPcUserRoleScopeTagInfo> userRoleScopeTags) {
            this.userRoleScopeTags = userRoleScopeTags;
            this.changedFields = changedFields.add("userRoleScopeTags");
            return this;
        }

        public Builder userRoleScopeTags(CloudPcUserRoleScopeTagInfo... userRoleScopeTags) {
            return userRoleScopeTags(Arrays.asList(userRoleScopeTags));
        }

        public Builder userRoleScopeTagsNextLink(String userRoleScopeTagsNextLink) {
            this.userRoleScopeTagsNextLink = userRoleScopeTagsNextLink;
            this.changedFields = changedFields.add("userRoleScopeTags");
            return this;
        }

        public CloudPcAuditActor build() {
            CloudPcAuditActor _x = new CloudPcAuditActor();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcAuditActor";
            _x.applicationDisplayName = applicationDisplayName;
            _x.applicationId = applicationId;
            _x.ipAddress = ipAddress;
            _x.remoteTenantId = remoteTenantId;
            _x.remoteUserId = remoteUserId;
            _x.servicePrincipalName = servicePrincipalName;
            _x.type = type;
            _x.userId = userId;
            _x.userPermissions = userPermissions;
            _x.userPermissionsNextLink = userPermissionsNextLink;
            _x.userPrincipalName = userPrincipalName;
            _x.userRoleScopeTags = userRoleScopeTags;
            _x.userRoleScopeTagsNextLink = userRoleScopeTagsNextLink;
            return _x;
        }
    }

    private CloudPcAuditActor _copy() {
        CloudPcAuditActor _x = new CloudPcAuditActor();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationDisplayName = applicationDisplayName;
        _x.applicationId = applicationId;
        _x.ipAddress = ipAddress;
        _x.remoteTenantId = remoteTenantId;
        _x.remoteUserId = remoteUserId;
        _x.servicePrincipalName = servicePrincipalName;
        _x.type = type;
        _x.userId = userId;
        _x.userPermissions = userPermissions;
        _x.userPrincipalName = userPrincipalName;
        _x.userRoleScopeTags = userRoleScopeTags;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcAuditActor[");
        b.append("applicationDisplayName=");
        b.append(this.applicationDisplayName);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("remoteTenantId=");
        b.append(this.remoteTenantId);
        b.append(", ");
        b.append("remoteUserId=");
        b.append(this.remoteUserId);
        b.append(", ");
        b.append("servicePrincipalName=");
        b.append(this.servicePrincipalName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPermissions=");
        b.append(this.userPermissions);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("userRoleScopeTags=");
        b.append(this.userRoleScopeTags);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
