package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudAppSecuritySessionControlType;

@JsonPropertyOrder({
    "@odata.type", 
    "cloudAppSecurityType"})
@JsonInclude(Include.NON_NULL)
public class CloudAppSecuritySessionControl extends ConditionalAccessSessionControl implements ODataType {

    @JsonProperty("cloudAppSecurityType")
    protected CloudAppSecuritySessionControlType cloudAppSecurityType;

    protected CloudAppSecuritySessionControl() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudAppSecuritySessionControl";
    }

    @Property(name="cloudAppSecurityType")
    @JsonIgnore
    public Optional<CloudAppSecuritySessionControlType> getCloudAppSecurityType() {
        return Optional.ofNullable(cloudAppSecurityType);
    }

    public CloudAppSecuritySessionControl withCloudAppSecurityType(CloudAppSecuritySessionControlType cloudAppSecurityType) {
        CloudAppSecuritySessionControl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudAppSecuritySessionControl");
        _x.cloudAppSecurityType = cloudAppSecurityType;
        return _x;
    }

    public CloudAppSecuritySessionControl withUnmappedField(String name, Object value) {
        CloudAppSecuritySessionControl _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudAppSecuritySessionControl() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private CloudAppSecuritySessionControlType cloudAppSecurityType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder cloudAppSecurityType(CloudAppSecuritySessionControlType cloudAppSecurityType) {
            this.cloudAppSecurityType = cloudAppSecurityType;
            this.changedFields = changedFields.add("cloudAppSecurityType");
            return this;
        }

        public CloudAppSecuritySessionControl build() {
            CloudAppSecuritySessionControl _x = new CloudAppSecuritySessionControl();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudAppSecuritySessionControl";
            _x.isEnabled = isEnabled;
            _x.cloudAppSecurityType = cloudAppSecurityType;
            return _x;
        }
    }

    private CloudAppSecuritySessionControl _copy() {
        CloudAppSecuritySessionControl _x = new CloudAppSecuritySessionControl();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.cloudAppSecurityType = cloudAppSecurityType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudAppSecuritySessionControl[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("cloudAppSecurityType=");
        b.append(this.cloudAppSecurityType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
