package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "activityId", 
    "clientRequestId", 
    "code", 
    "errorDateTime"})
@JsonInclude(Include.NON_NULL)
public class ClassificationInnerError implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("activityId")
    protected String activityId;

    @JsonProperty("clientRequestId")
    protected String clientRequestId;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("errorDateTime")
    protected OffsetDateTime errorDateTime;

    protected ClassificationInnerError() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.classificationInnerError";
    }

    @Property(name="activityId")
    @JsonIgnore
    public Optional<String> getActivityId() {
        return Optional.ofNullable(activityId);
    }

    public ClassificationInnerError withActivityId(String activityId) {
        ClassificationInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationInnerError");
        _x.activityId = activityId;
        return _x;
    }

    @Property(name="clientRequestId")
    @JsonIgnore
    public Optional<String> getClientRequestId() {
        return Optional.ofNullable(clientRequestId);
    }

    public ClassificationInnerError withClientRequestId(String clientRequestId) {
        ClassificationInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationInnerError");
        _x.clientRequestId = clientRequestId;
        return _x;
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public ClassificationInnerError withCode(String code) {
        ClassificationInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationInnerError");
        _x.code = code;
        return _x;
    }

    @Property(name="errorDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getErrorDateTime() {
        return Optional.ofNullable(errorDateTime);
    }

    public ClassificationInnerError withErrorDateTime(OffsetDateTime errorDateTime) {
        ClassificationInnerError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationInnerError");
        _x.errorDateTime = errorDateTime;
        return _x;
    }

    public ClassificationInnerError withUnmappedField(String name, Object value) {
        ClassificationInnerError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String activityId;
        private String clientRequestId;
        private String code;
        private OffsetDateTime errorDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder activityId(String activityId) {
            this.activityId = activityId;
            this.changedFields = changedFields.add("activityId");
            return this;
        }

        public Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            this.changedFields = changedFields.add("clientRequestId");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder errorDateTime(OffsetDateTime errorDateTime) {
            this.errorDateTime = errorDateTime;
            this.changedFields = changedFields.add("errorDateTime");
            return this;
        }

        public ClassificationInnerError build() {
            ClassificationInnerError _x = new ClassificationInnerError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.classificationInnerError";
            _x.activityId = activityId;
            _x.clientRequestId = clientRequestId;
            _x.code = code;
            _x.errorDateTime = errorDateTime;
            return _x;
        }
    }

    private ClassificationInnerError _copy() {
        ClassificationInnerError _x = new ClassificationInnerError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.activityId = activityId;
        _x.clientRequestId = clientRequestId;
        _x.code = code;
        _x.errorDateTime = errorDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClassificationInnerError[");
        b.append("activityId=");
        b.append(this.activityId);
        b.append(", ");
        b.append("clientRequestId=");
        b.append(this.clientRequestId);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("errorDateTime=");
        b.append(this.errorDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
