package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "confidence", 
    "count"})
@JsonInclude(Include.NON_NULL)
public class ClassificationAttribute implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("count")
    protected Integer count;

    protected ClassificationAttribute() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.classificationAttribute";
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public ClassificationAttribute withConfidence(Integer confidence) {
        ClassificationAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationAttribute");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public ClassificationAttribute withCount(Integer count) {
        ClassificationAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.classificationAttribute");
        _x.count = count;
        return _x;
    }

    public ClassificationAttribute withUnmappedField(String name, Object value) {
        ClassificationAttribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidence;
        private Integer count;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public ClassificationAttribute build() {
            ClassificationAttribute _x = new ClassificationAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.classificationAttribute";
            _x.confidence = confidence;
            _x.count = count;
            return _x;
        }
    }

    private ClassificationAttribute _copy() {
        ClassificationAttribute _x = new ClassificationAttribute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidence = confidence;
        _x.count = count;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClassificationAttribute[");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
