package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "email", 
    "givenName", 
    "surname", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class ClaimsMapping implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("userId")
    protected String userId;

    protected ClaimsMapping() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.claimsMapping";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ClaimsMapping withDisplayName(String displayName) {
        ClaimsMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.claimsMapping");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public ClaimsMapping withEmail(String email) {
        ClaimsMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.claimsMapping");
        _x.email = email;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public ClaimsMapping withGivenName(String givenName) {
        ClaimsMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.claimsMapping");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public ClaimsMapping withSurname(String surname) {
        ClaimsMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.claimsMapping");
        _x.surname = surname;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public ClaimsMapping withUserId(String userId) {
        ClaimsMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.claimsMapping");
        _x.userId = userId;
        return _x;
    }

    public ClaimsMapping withUnmappedField(String name, Object value) {
        ClaimsMapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String email;
        private String givenName;
        private String surname;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public ClaimsMapping build() {
            ClaimsMapping _x = new ClaimsMapping();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.claimsMapping";
            _x.displayName = displayName;
            _x.email = email;
            _x.givenName = givenName;
            _x.surname = surname;
            _x.userId = userId;
            return _x;
        }
    }

    private ClaimsMapping _copy() {
        ClaimsMapping _x = new ClaimsMapping();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.email = email;
        _x.givenName = givenName;
        _x.surname = surname;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClaimsMapping[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
