package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "chatDisplayName", 
    "chatId", 
    "initiator"})
@JsonInclude(Include.NON_NULL)
public class ChatRenamedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("chatDisplayName")
    protected String chatDisplayName;

    @JsonProperty("chatId")
    protected String chatId;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    protected ChatRenamedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatRenamedEventMessageDetail";
    }

    @Property(name="chatDisplayName")
    @JsonIgnore
    public Optional<String> getChatDisplayName() {
        return Optional.ofNullable(chatDisplayName);
    }

    public ChatRenamedEventMessageDetail withChatDisplayName(String chatDisplayName) {
        ChatRenamedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatRenamedEventMessageDetail");
        _x.chatDisplayName = chatDisplayName;
        return _x;
    }

    @Property(name="chatId")
    @JsonIgnore
    public Optional<String> getChatId() {
        return Optional.ofNullable(chatId);
    }

    public ChatRenamedEventMessageDetail withChatId(String chatId) {
        ChatRenamedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatRenamedEventMessageDetail");
        _x.chatId = chatId;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public ChatRenamedEventMessageDetail withInitiator(IdentitySet initiator) {
        ChatRenamedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatRenamedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    public ChatRenamedEventMessageDetail withUnmappedField(String name, Object value) {
        ChatRenamedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChatRenamedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String chatDisplayName;
        private String chatId;
        private IdentitySet initiator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder chatDisplayName(String chatDisplayName) {
            this.chatDisplayName = chatDisplayName;
            this.changedFields = changedFields.add("chatDisplayName");
            return this;
        }

        public Builder chatId(String chatId) {
            this.chatId = chatId;
            this.changedFields = changedFields.add("chatId");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public ChatRenamedEventMessageDetail build() {
            ChatRenamedEventMessageDetail _x = new ChatRenamedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatRenamedEventMessageDetail";
            _x.chatDisplayName = chatDisplayName;
            _x.chatId = chatId;
            _x.initiator = initiator;
            return _x;
        }
    }

    private ChatRenamedEventMessageDetail _copy() {
        ChatRenamedEventMessageDetail _x = new ChatRenamedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.chatDisplayName = chatDisplayName;
        _x.chatId = chatId;
        _x.initiator = initiator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatRenamedEventMessageDetail[");
        b.append("chatDisplayName=");
        b.append(this.chatDisplayName);
        b.append(", ");
        b.append("chatId=");
        b.append(this.chatId);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
