package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "complianceUrl", 
    "generalText", 
    "matchedConditionDescriptions"})
@JsonInclude(Include.NON_NULL)
public class ChatMessagePolicyViolationPolicyTip implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("complianceUrl")
    protected String complianceUrl;

    @JsonProperty("generalText")
    protected String generalText;

    @JsonProperty("matchedConditionDescriptions")
    protected List<String> matchedConditionDescriptions;

    @JsonProperty("matchedConditionDescriptions@nextLink")
    protected String matchedConditionDescriptionsNextLink;

    protected ChatMessagePolicyViolationPolicyTip() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessagePolicyViolationPolicyTip";
    }

    @Property(name="complianceUrl")
    @JsonIgnore
    public Optional<String> getComplianceUrl() {
        return Optional.ofNullable(complianceUrl);
    }

    public ChatMessagePolicyViolationPolicyTip withComplianceUrl(String complianceUrl) {
        ChatMessagePolicyViolationPolicyTip _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolationPolicyTip");
        _x.complianceUrl = complianceUrl;
        return _x;
    }

    @Property(name="generalText")
    @JsonIgnore
    public Optional<String> getGeneralText() {
        return Optional.ofNullable(generalText);
    }

    public ChatMessagePolicyViolationPolicyTip withGeneralText(String generalText) {
        ChatMessagePolicyViolationPolicyTip _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolationPolicyTip");
        _x.generalText = generalText;
        return _x;
    }

    @Property(name="matchedConditionDescriptions")
    @JsonIgnore
    public CollectionPage<String> getMatchedConditionDescriptions() {
        return new CollectionPage<String>(contextPath, String.class, this.matchedConditionDescriptions, Optional.ofNullable(matchedConditionDescriptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matchedConditionDescriptions")
    @JsonIgnore
    public CollectionPage<String> getMatchedConditionDescriptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.matchedConditionDescriptions, Optional.ofNullable(matchedConditionDescriptionsNextLink), Collections.emptyList(), options);
    }

    public ChatMessagePolicyViolationPolicyTip withUnmappedField(String name, Object value) {
        ChatMessagePolicyViolationPolicyTip _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String complianceUrl;
        private String generalText;
        private List<String> matchedConditionDescriptions;
        private String matchedConditionDescriptionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder complianceUrl(String complianceUrl) {
            this.complianceUrl = complianceUrl;
            this.changedFields = changedFields.add("complianceUrl");
            return this;
        }

        public Builder generalText(String generalText) {
            this.generalText = generalText;
            this.changedFields = changedFields.add("generalText");
            return this;
        }

        public Builder matchedConditionDescriptions(List<String> matchedConditionDescriptions) {
            this.matchedConditionDescriptions = matchedConditionDescriptions;
            this.changedFields = changedFields.add("matchedConditionDescriptions");
            return this;
        }

        public Builder matchedConditionDescriptions(String... matchedConditionDescriptions) {
            return matchedConditionDescriptions(Arrays.asList(matchedConditionDescriptions));
        }

        public Builder matchedConditionDescriptionsNextLink(String matchedConditionDescriptionsNextLink) {
            this.matchedConditionDescriptionsNextLink = matchedConditionDescriptionsNextLink;
            this.changedFields = changedFields.add("matchedConditionDescriptions");
            return this;
        }

        public ChatMessagePolicyViolationPolicyTip build() {
            ChatMessagePolicyViolationPolicyTip _x = new ChatMessagePolicyViolationPolicyTip();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessagePolicyViolationPolicyTip";
            _x.complianceUrl = complianceUrl;
            _x.generalText = generalText;
            _x.matchedConditionDescriptions = matchedConditionDescriptions;
            _x.matchedConditionDescriptionsNextLink = matchedConditionDescriptionsNextLink;
            return _x;
        }
    }

    private ChatMessagePolicyViolationPolicyTip _copy() {
        ChatMessagePolicyViolationPolicyTip _x = new ChatMessagePolicyViolationPolicyTip();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.complianceUrl = complianceUrl;
        _x.generalText = generalText;
        _x.matchedConditionDescriptions = matchedConditionDescriptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessagePolicyViolationPolicyTip[");
        b.append("complianceUrl=");
        b.append(this.complianceUrl);
        b.append(", ");
        b.append("generalText=");
        b.append(this.generalText);
        b.append(", ");
        b.append("matchedConditionDescriptions=");
        b.append(this.matchedConditionDescriptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
