package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "conversation", 
    "tag"})
@JsonInclude(Include.NON_NULL)
public class ChatMessageMentionedIdentitySet extends IdentitySet implements ODataType {

    @JsonProperty("conversation")
    protected TeamworkConversationIdentity conversation;

    @JsonProperty("tag")
    protected TeamworkTagIdentity tag;

    protected ChatMessageMentionedIdentitySet() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessageMentionedIdentitySet";
    }

    @Property(name="conversation")
    @JsonIgnore
    public Optional<TeamworkConversationIdentity> getConversation() {
        return Optional.ofNullable(conversation);
    }

    public ChatMessageMentionedIdentitySet withConversation(TeamworkConversationIdentity conversation) {
        ChatMessageMentionedIdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageMentionedIdentitySet");
        _x.conversation = conversation;
        return _x;
    }

    @Property(name="tag")
    @JsonIgnore
    public Optional<TeamworkTagIdentity> getTag() {
        return Optional.ofNullable(tag);
    }

    public ChatMessageMentionedIdentitySet withTag(TeamworkTagIdentity tag) {
        ChatMessageMentionedIdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageMentionedIdentitySet");
        _x.tag = tag;
        return _x;
    }

    public ChatMessageMentionedIdentitySet withUnmappedField(String name, Object value) {
        ChatMessageMentionedIdentitySet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChatMessageMentionedIdentitySet() {
        return new Builder();
    }

    public static final class Builder {
        private Identity application;
        private Identity device;
        private Identity user;
        private TeamworkConversationIdentity conversation;
        private TeamworkTagIdentity tag;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder application(Identity application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder device(Identity device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public Builder user(Identity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public Builder conversation(TeamworkConversationIdentity conversation) {
            this.conversation = conversation;
            this.changedFields = changedFields.add("conversation");
            return this;
        }

        public Builder tag(TeamworkTagIdentity tag) {
            this.tag = tag;
            this.changedFields = changedFields.add("tag");
            return this;
        }

        public ChatMessageMentionedIdentitySet build() {
            ChatMessageMentionedIdentitySet _x = new ChatMessageMentionedIdentitySet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessageMentionedIdentitySet";
            _x.application = application;
            _x.device = device;
            _x.user = user;
            _x.conversation = conversation;
            _x.tag = tag;
            return _x;
        }
    }

    private ChatMessageMentionedIdentitySet _copy() {
        ChatMessageMentionedIdentitySet _x = new ChatMessageMentionedIdentitySet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.application = application;
        _x.device = device;
        _x.user = user;
        _x.conversation = conversation;
        _x.tag = tag;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessageMentionedIdentitySet[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append(", ");
        b.append("conversation=");
        b.append(this.conversation);
        b.append(", ");
        b.append("tag=");
        b.append(this.tag);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
