package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class ChatMessageFromIdentitySet extends IdentitySet implements ODataType {

    protected ChatMessageFromIdentitySet() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessageFromIdentitySet";
    }

    public ChatMessageFromIdentitySet withUnmappedField(String name, Object value) {
        ChatMessageFromIdentitySet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChatMessageFromIdentitySet() {
        return new Builder();
    }

    public static final class Builder {
        private Identity application;
        private Identity device;
        private Identity user;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder application(Identity application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder device(Identity device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public Builder user(Identity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public ChatMessageFromIdentitySet build() {
            ChatMessageFromIdentitySet _x = new ChatMessageFromIdentitySet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessageFromIdentitySet";
            _x.application = application;
            _x.device = device;
            _x.user = user;
            return _x;
        }
    }

    private ChatMessageFromIdentitySet _copy() {
        ChatMessageFromIdentitySet _x = new ChatMessageFromIdentitySet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.application = application;
        _x.device = device;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessageFromIdentitySet[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
