package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "channelId", 
    "initiator"})
@JsonInclude(Include.NON_NULL)
public class ChannelSetAsFavoriteByDefaultEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("channelId")
    protected String channelId;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    protected ChannelSetAsFavoriteByDefaultEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.channelSetAsFavoriteByDefaultEventMessageDetail";
    }

    @Property(name="channelId")
    @JsonIgnore
    public Optional<String> getChannelId() {
        return Optional.ofNullable(channelId);
    }

    public ChannelSetAsFavoriteByDefaultEventMessageDetail withChannelId(String channelId) {
        ChannelSetAsFavoriteByDefaultEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelSetAsFavoriteByDefaultEventMessageDetail");
        _x.channelId = channelId;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public ChannelSetAsFavoriteByDefaultEventMessageDetail withInitiator(IdentitySet initiator) {
        ChannelSetAsFavoriteByDefaultEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelSetAsFavoriteByDefaultEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    public ChannelSetAsFavoriteByDefaultEventMessageDetail withUnmappedField(String name, Object value) {
        ChannelSetAsFavoriteByDefaultEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChannelSetAsFavoriteByDefaultEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String channelId;
        private IdentitySet initiator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            this.changedFields = changedFields.add("channelId");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public ChannelSetAsFavoriteByDefaultEventMessageDetail build() {
            ChannelSetAsFavoriteByDefaultEventMessageDetail _x = new ChannelSetAsFavoriteByDefaultEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.channelSetAsFavoriteByDefaultEventMessageDetail";
            _x.channelId = channelId;
            _x.initiator = initiator;
            return _x;
        }
    }

    private ChannelSetAsFavoriteByDefaultEventMessageDetail _copy() {
        ChannelSetAsFavoriteByDefaultEventMessageDetail _x = new ChannelSetAsFavoriteByDefaultEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.channelId = channelId;
        _x.initiator = initiator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChannelSetAsFavoriteByDefaultEventMessageDetail[");
        b.append("channelId=");
        b.append(this.channelId);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
