package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "data", 
    "dataKey", 
    "dataSignature", 
    "encryptionCertificateId", 
    "encryptionCertificateThumbprint"})
@JsonInclude(Include.NON_NULL)
public class ChangeNotificationEncryptedContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("dataKey")
    protected String dataKey;

    @JsonProperty("dataSignature")
    protected String dataSignature;

    @JsonProperty("encryptionCertificateId")
    protected String encryptionCertificateId;

    @JsonProperty("encryptionCertificateThumbprint")
    protected String encryptionCertificateThumbprint;

    protected ChangeNotificationEncryptedContent() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.changeNotificationEncryptedContent";
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public ChangeNotificationEncryptedContent withData(String data) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotificationEncryptedContent");
        _x.data = data;
        return _x;
    }

    @Property(name="dataKey")
    @JsonIgnore
    public Optional<String> getDataKey() {
        return Optional.ofNullable(dataKey);
    }

    public ChangeNotificationEncryptedContent withDataKey(String dataKey) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotificationEncryptedContent");
        _x.dataKey = dataKey;
        return _x;
    }

    @Property(name="dataSignature")
    @JsonIgnore
    public Optional<String> getDataSignature() {
        return Optional.ofNullable(dataSignature);
    }

    public ChangeNotificationEncryptedContent withDataSignature(String dataSignature) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotificationEncryptedContent");
        _x.dataSignature = dataSignature;
        return _x;
    }

    @Property(name="encryptionCertificateId")
    @JsonIgnore
    public Optional<String> getEncryptionCertificateId() {
        return Optional.ofNullable(encryptionCertificateId);
    }

    public ChangeNotificationEncryptedContent withEncryptionCertificateId(String encryptionCertificateId) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotificationEncryptedContent");
        _x.encryptionCertificateId = encryptionCertificateId;
        return _x;
    }

    @Property(name="encryptionCertificateThumbprint")
    @JsonIgnore
    public Optional<String> getEncryptionCertificateThumbprint() {
        return Optional.ofNullable(encryptionCertificateThumbprint);
    }

    public ChangeNotificationEncryptedContent withEncryptionCertificateThumbprint(String encryptionCertificateThumbprint) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotificationEncryptedContent");
        _x.encryptionCertificateThumbprint = encryptionCertificateThumbprint;
        return _x;
    }

    public ChangeNotificationEncryptedContent withUnmappedField(String name, Object value) {
        ChangeNotificationEncryptedContent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String data;
        private String dataKey;
        private String dataSignature;
        private String encryptionCertificateId;
        private String encryptionCertificateThumbprint;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder dataKey(String dataKey) {
            this.dataKey = dataKey;
            this.changedFields = changedFields.add("dataKey");
            return this;
        }

        public Builder dataSignature(String dataSignature) {
            this.dataSignature = dataSignature;
            this.changedFields = changedFields.add("dataSignature");
            return this;
        }

        public Builder encryptionCertificateId(String encryptionCertificateId) {
            this.encryptionCertificateId = encryptionCertificateId;
            this.changedFields = changedFields.add("encryptionCertificateId");
            return this;
        }

        public Builder encryptionCertificateThumbprint(String encryptionCertificateThumbprint) {
            this.encryptionCertificateThumbprint = encryptionCertificateThumbprint;
            this.changedFields = changedFields.add("encryptionCertificateThumbprint");
            return this;
        }

        public ChangeNotificationEncryptedContent build() {
            ChangeNotificationEncryptedContent _x = new ChangeNotificationEncryptedContent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.changeNotificationEncryptedContent";
            _x.data = data;
            _x.dataKey = dataKey;
            _x.dataSignature = dataSignature;
            _x.encryptionCertificateId = encryptionCertificateId;
            _x.encryptionCertificateThumbprint = encryptionCertificateThumbprint;
            return _x;
        }
    }

    private ChangeNotificationEncryptedContent _copy() {
        ChangeNotificationEncryptedContent _x = new ChangeNotificationEncryptedContent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.data = data;
        _x.dataKey = dataKey;
        _x.dataSignature = dataSignature;
        _x.encryptionCertificateId = encryptionCertificateId;
        _x.encryptionCertificateThumbprint = encryptionCertificateThumbprint;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChangeNotificationEncryptedContent[");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("dataKey=");
        b.append(this.dataKey);
        b.append(", ");
        b.append("dataSignature=");
        b.append(this.dataSignature);
        b.append(", ");
        b.append("encryptionCertificateId=");
        b.append(this.encryptionCertificateId);
        b.append(", ");
        b.append("encryptionCertificateThumbprint=");
        b.append(this.encryptionCertificateThumbprint);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
