package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Certificate connector settings.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certExpiryTime", 
    "connectorVersion", 
    "enrollmentError", 
    "lastConnectorConnectionTime", 
    "lastUploadVersion", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CertificateConnectorSetting implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("certExpiryTime")
    protected OffsetDateTime certExpiryTime;

    @JsonProperty("connectorVersion")
    protected String connectorVersion;

    @JsonProperty("enrollmentError")
    protected String enrollmentError;

    @JsonProperty("lastConnectorConnectionTime")
    protected OffsetDateTime lastConnectorConnectionTime;

    @JsonProperty("lastUploadVersion")
    protected Long lastUploadVersion;

    @JsonProperty("status")
    protected Integer status;

    protected CertificateConnectorSetting() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.certificateConnectorSetting";
    }

    /**
     * <i>“Certificate expire time”</i>
     * 
     * @return property certExpiryTime
     */
    @Property(name="certExpiryTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCertExpiryTime() {
        return Optional.ofNullable(certExpiryTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certExpiryTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate expire time”</i>
     * 
     * @param certExpiryTime
     *            new value of {@code certExpiryTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certExpiryTime} field changed
     */
    public CertificateConnectorSetting withCertExpiryTime(OffsetDateTime certExpiryTime) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.certExpiryTime = certExpiryTime;
        return _x;
    }

    /**
     * <i>“Version of certificate connector”</i>
     * 
     * @return property connectorVersion
     */
    @Property(name="connectorVersion")
    @JsonIgnore
    public Optional<String> getConnectorVersion() {
        return Optional.ofNullable(connectorVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectorVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Version of certificate connector”</i>
     * 
     * @param connectorVersion
     *            new value of {@code connectorVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectorVersion} field changed
     */
    public CertificateConnectorSetting withConnectorVersion(String connectorVersion) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.connectorVersion = connectorVersion;
        return _x;
    }

    /**
     * <i>“Certificate connector enrollment error”</i>
     * 
     * @return property enrollmentError
     */
    @Property(name="enrollmentError")
    @JsonIgnore
    public Optional<String> getEnrollmentError() {
        return Optional.ofNullable(enrollmentError);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentError}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Certificate connector enrollment error”</i>
     * 
     * @param enrollmentError
     *            new value of {@code enrollmentError} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentError} field changed
     */
    public CertificateConnectorSetting withEnrollmentError(String enrollmentError) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.enrollmentError = enrollmentError;
        return _x;
    }

    /**
     * <i>“Last time certificate connector connected”</i>
     * 
     * @return property lastConnectorConnectionTime
     */
    @Property(name="lastConnectorConnectionTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConnectorConnectionTime() {
        return Optional.ofNullable(lastConnectorConnectionTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastConnectorConnectionTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Last time certificate connector connected”</i>
     * 
     * @param lastConnectorConnectionTime
     *            new value of {@code lastConnectorConnectionTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastConnectorConnectionTime} field changed
     */
    public CertificateConnectorSetting withLastConnectorConnectionTime(OffsetDateTime lastConnectorConnectionTime) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.lastConnectorConnectionTime = lastConnectorConnectionTime;
        return _x;
    }

    /**
     * <i>“Version of last uploaded certificate connector”</i>
     * 
     * @return property lastUploadVersion
     */
    @Property(name="lastUploadVersion")
    @JsonIgnore
    public Optional<Long> getLastUploadVersion() {
        return Optional.ofNullable(lastUploadVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastUploadVersion
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Version of last uploaded certificate connector”</i>
     * 
     * @param lastUploadVersion
     *            new value of {@code lastUploadVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUploadVersion} field changed
     */
    public CertificateConnectorSetting withLastUploadVersion(Long lastUploadVersion) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.lastUploadVersion = lastUploadVersion;
        return _x;
    }

    /**
     * <i>“Certificate connector status”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<Integer> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Certificate connector status”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public CertificateConnectorSetting withStatus(Integer status) {
        CertificateConnectorSetting _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorSetting");
        _x.status = status;
        return _x;
    }

    public CertificateConnectorSetting withUnmappedField(String name, Object value) {
        CertificateConnectorSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime certExpiryTime;
        private String connectorVersion;
        private String enrollmentError;
        private OffsetDateTime lastConnectorConnectionTime;
        private Long lastUploadVersion;
        private Integer status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Certificate expire time”</i>
         * 
         * @param certExpiryTime
         *            value of {@code certExpiryTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certExpiryTime(OffsetDateTime certExpiryTime) {
            this.certExpiryTime = certExpiryTime;
            this.changedFields = changedFields.add("certExpiryTime");
            return this;
        }

        /**
         * <i>“Version of certificate connector”</i>
         * 
         * @param connectorVersion
         *            value of {@code connectorVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
            this.changedFields = changedFields.add("connectorVersion");
            return this;
        }

        /**
         * <i>“Certificate connector enrollment error”</i>
         * 
         * @param enrollmentError
         *            value of {@code enrollmentError} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentError(String enrollmentError) {
            this.enrollmentError = enrollmentError;
            this.changedFields = changedFields.add("enrollmentError");
            return this;
        }

        /**
         * <i>“Last time certificate connector connected”</i>
         * 
         * @param lastConnectorConnectionTime
         *            value of {@code lastConnectorConnectionTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastConnectorConnectionTime(OffsetDateTime lastConnectorConnectionTime) {
            this.lastConnectorConnectionTime = lastConnectorConnectionTime;
            this.changedFields = changedFields.add("lastConnectorConnectionTime");
            return this;
        }

        /**
         * <i>“Version of last uploaded certificate connector”</i>
         * 
         * @param lastUploadVersion
         *            value of {@code lastUploadVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUploadVersion(Long lastUploadVersion) {
            this.lastUploadVersion = lastUploadVersion;
            this.changedFields = changedFields.add("lastUploadVersion");
            return this;
        }

        /**
         * <i>“Certificate connector status”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(Integer status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CertificateConnectorSetting build() {
            CertificateConnectorSetting _x = new CertificateConnectorSetting();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.certificateConnectorSetting";
            _x.certExpiryTime = certExpiryTime;
            _x.connectorVersion = connectorVersion;
            _x.enrollmentError = enrollmentError;
            _x.lastConnectorConnectionTime = lastConnectorConnectionTime;
            _x.lastUploadVersion = lastUploadVersion;
            _x.status = status;
            return _x;
        }
    }

    private CertificateConnectorSetting _copy() {
        CertificateConnectorSetting _x = new CertificateConnectorSetting();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.certExpiryTime = certExpiryTime;
        _x.connectorVersion = connectorVersion;
        _x.enrollmentError = enrollmentError;
        _x.lastConnectorConnectionTime = lastConnectorConnectionTime;
        _x.lastUploadVersion = lastUploadVersion;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CertificateConnectorSetting[");
        b.append("certExpiryTime=");
        b.append(this.certExpiryTime);
        b.append(", ");
        b.append("connectorVersion=");
        b.append(this.connectorVersion);
        b.append(", ");
        b.append("enrollmentError=");
        b.append(this.enrollmentError);
        b.append(", ");
        b.append("lastConnectorConnectionTime=");
        b.append(this.lastConnectorConnectionTime);
        b.append(", ");
        b.append("lastUploadVersion=");
        b.append(this.lastUploadVersion);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
