package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "callId", 
    "callTranscriptICalUid", 
    "meetingOrganizer"})
@JsonInclude(Include.NON_NULL)
public class CallTranscriptEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("callId")
    protected String callId;

    @JsonProperty("callTranscriptICalUid")
    protected String callTranscriptICalUid;

    @JsonProperty("meetingOrganizer")
    protected IdentitySet meetingOrganizer;

    protected CallTranscriptEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callTranscriptEventMessageDetail";
    }

    @Property(name="callId")
    @JsonIgnore
    public Optional<String> getCallId() {
        return Optional.ofNullable(callId);
    }

    public CallTranscriptEventMessageDetail withCallId(String callId) {
        CallTranscriptEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callTranscriptEventMessageDetail");
        _x.callId = callId;
        return _x;
    }

    @Property(name="callTranscriptICalUid")
    @JsonIgnore
    public Optional<String> getCallTranscriptICalUid() {
        return Optional.ofNullable(callTranscriptICalUid);
    }

    public CallTranscriptEventMessageDetail withCallTranscriptICalUid(String callTranscriptICalUid) {
        CallTranscriptEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callTranscriptEventMessageDetail");
        _x.callTranscriptICalUid = callTranscriptICalUid;
        return _x;
    }

    @Property(name="meetingOrganizer")
    @JsonIgnore
    public Optional<IdentitySet> getMeetingOrganizer() {
        return Optional.ofNullable(meetingOrganizer);
    }

    public CallTranscriptEventMessageDetail withMeetingOrganizer(IdentitySet meetingOrganizer) {
        CallTranscriptEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callTranscriptEventMessageDetail");
        _x.meetingOrganizer = meetingOrganizer;
        return _x;
    }

    public CallTranscriptEventMessageDetail withUnmappedField(String name, Object value) {
        CallTranscriptEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallTranscriptEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String callId;
        private String callTranscriptICalUid;
        private IdentitySet meetingOrganizer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callId(String callId) {
            this.callId = callId;
            this.changedFields = changedFields.add("callId");
            return this;
        }

        public Builder callTranscriptICalUid(String callTranscriptICalUid) {
            this.callTranscriptICalUid = callTranscriptICalUid;
            this.changedFields = changedFields.add("callTranscriptICalUid");
            return this;
        }

        public Builder meetingOrganizer(IdentitySet meetingOrganizer) {
            this.meetingOrganizer = meetingOrganizer;
            this.changedFields = changedFields.add("meetingOrganizer");
            return this;
        }

        public CallTranscriptEventMessageDetail build() {
            CallTranscriptEventMessageDetail _x = new CallTranscriptEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callTranscriptEventMessageDetail";
            _x.callId = callId;
            _x.callTranscriptICalUid = callTranscriptICalUid;
            _x.meetingOrganizer = meetingOrganizer;
            return _x;
        }
    }

    private CallTranscriptEventMessageDetail _copy() {
        CallTranscriptEventMessageDetail _x = new CallTranscriptEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callId = callId;
        _x.callTranscriptICalUid = callTranscriptICalUid;
        _x.meetingOrganizer = meetingOrganizer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallTranscriptEventMessageDetail[");
        b.append("callId=");
        b.append(this.callId);
        b.append(", ");
        b.append("callTranscriptICalUid=");
        b.append(this.callTranscriptICalUid);
        b.append(", ");
        b.append("meetingOrganizer=");
        b.append(this.meetingOrganizer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
