package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.TeamworkCallEventType;

@JsonPropertyOrder({
    "@odata.type", 
    "callEventType", 
    "callId", 
    "initiator"})
@JsonInclude(Include.NON_NULL)
public class CallStartedEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("callEventType")
    protected TeamworkCallEventType callEventType;

    @JsonProperty("callId")
    protected String callId;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    protected CallStartedEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callStartedEventMessageDetail";
    }

    @Property(name="callEventType")
    @JsonIgnore
    public Optional<TeamworkCallEventType> getCallEventType() {
        return Optional.ofNullable(callEventType);
    }

    public CallStartedEventMessageDetail withCallEventType(TeamworkCallEventType callEventType) {
        CallStartedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callStartedEventMessageDetail");
        _x.callEventType = callEventType;
        return _x;
    }

    @Property(name="callId")
    @JsonIgnore
    public Optional<String> getCallId() {
        return Optional.ofNullable(callId);
    }

    public CallStartedEventMessageDetail withCallId(String callId) {
        CallStartedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callStartedEventMessageDetail");
        _x.callId = callId;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public CallStartedEventMessageDetail withInitiator(IdentitySet initiator) {
        CallStartedEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callStartedEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    public CallStartedEventMessageDetail withUnmappedField(String name, Object value) {
        CallStartedEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallStartedEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private TeamworkCallEventType callEventType;
        private String callId;
        private IdentitySet initiator;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callEventType(TeamworkCallEventType callEventType) {
            this.callEventType = callEventType;
            this.changedFields = changedFields.add("callEventType");
            return this;
        }

        public Builder callId(String callId) {
            this.callId = callId;
            this.changedFields = changedFields.add("callId");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public CallStartedEventMessageDetail build() {
            CallStartedEventMessageDetail _x = new CallStartedEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callStartedEventMessageDetail";
            _x.callEventType = callEventType;
            _x.callId = callId;
            _x.initiator = initiator;
            return _x;
        }
    }

    private CallStartedEventMessageDetail _copy() {
        CallStartedEventMessageDetail _x = new CallStartedEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callEventType = callEventType;
        _x.callId = callId;
        _x.initiator = initiator;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallStartedEventMessageDetail[");
        b.append("callEventType=");
        b.append(this.callEventType);
        b.append(", ");
        b.append("callId=");
        b.append(this.callId);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
