package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CallRecordingStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "callId", 
    "callRecordingDisplayName", 
    "callRecordingDuration", 
    "callRecordingStatus", 
    "callRecordingUrl", 
    "initiator", 
    "meetingOrganizer"})
@JsonInclude(Include.NON_NULL)
public class CallRecordingEventMessageDetail extends EventMessageDetail implements ODataType {

    @JsonProperty("callId")
    protected String callId;

    @JsonProperty("callRecordingDisplayName")
    protected String callRecordingDisplayName;

    @JsonProperty("callRecordingDuration")
    protected Duration callRecordingDuration;

    @JsonProperty("callRecordingStatus")
    protected CallRecordingStatus callRecordingStatus;

    @JsonProperty("callRecordingUrl")
    protected String callRecordingUrl;

    @JsonProperty("initiator")
    protected IdentitySet initiator;

    @JsonProperty("meetingOrganizer")
    protected IdentitySet meetingOrganizer;

    protected CallRecordingEventMessageDetail() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecordingEventMessageDetail";
    }

    @Property(name="callId")
    @JsonIgnore
    public Optional<String> getCallId() {
        return Optional.ofNullable(callId);
    }

    public CallRecordingEventMessageDetail withCallId(String callId) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.callId = callId;
        return _x;
    }

    @Property(name="callRecordingDisplayName")
    @JsonIgnore
    public Optional<String> getCallRecordingDisplayName() {
        return Optional.ofNullable(callRecordingDisplayName);
    }

    public CallRecordingEventMessageDetail withCallRecordingDisplayName(String callRecordingDisplayName) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.callRecordingDisplayName = callRecordingDisplayName;
        return _x;
    }

    @Property(name="callRecordingDuration")
    @JsonIgnore
    public Optional<Duration> getCallRecordingDuration() {
        return Optional.ofNullable(callRecordingDuration);
    }

    public CallRecordingEventMessageDetail withCallRecordingDuration(Duration callRecordingDuration) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.callRecordingDuration = callRecordingDuration;
        return _x;
    }

    @Property(name="callRecordingStatus")
    @JsonIgnore
    public Optional<CallRecordingStatus> getCallRecordingStatus() {
        return Optional.ofNullable(callRecordingStatus);
    }

    public CallRecordingEventMessageDetail withCallRecordingStatus(CallRecordingStatus callRecordingStatus) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.callRecordingStatus = callRecordingStatus;
        return _x;
    }

    @Property(name="callRecordingUrl")
    @JsonIgnore
    public Optional<String> getCallRecordingUrl() {
        return Optional.ofNullable(callRecordingUrl);
    }

    public CallRecordingEventMessageDetail withCallRecordingUrl(String callRecordingUrl) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.callRecordingUrl = callRecordingUrl;
        return _x;
    }

    @Property(name="initiator")
    @JsonIgnore
    public Optional<IdentitySet> getInitiator() {
        return Optional.ofNullable(initiator);
    }

    public CallRecordingEventMessageDetail withInitiator(IdentitySet initiator) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.initiator = initiator;
        return _x;
    }

    @Property(name="meetingOrganizer")
    @JsonIgnore
    public Optional<IdentitySet> getMeetingOrganizer() {
        return Optional.ofNullable(meetingOrganizer);
    }

    public CallRecordingEventMessageDetail withMeetingOrganizer(IdentitySet meetingOrganizer) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecordingEventMessageDetail");
        _x.meetingOrganizer = meetingOrganizer;
        return _x;
    }

    public CallRecordingEventMessageDetail withUnmappedField(String name, Object value) {
        CallRecordingEventMessageDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallRecordingEventMessageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String callId;
        private String callRecordingDisplayName;
        private Duration callRecordingDuration;
        private CallRecordingStatus callRecordingStatus;
        private String callRecordingUrl;
        private IdentitySet initiator;
        private IdentitySet meetingOrganizer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder callId(String callId) {
            this.callId = callId;
            this.changedFields = changedFields.add("callId");
            return this;
        }

        public Builder callRecordingDisplayName(String callRecordingDisplayName) {
            this.callRecordingDisplayName = callRecordingDisplayName;
            this.changedFields = changedFields.add("callRecordingDisplayName");
            return this;
        }

        public Builder callRecordingDuration(Duration callRecordingDuration) {
            this.callRecordingDuration = callRecordingDuration;
            this.changedFields = changedFields.add("callRecordingDuration");
            return this;
        }

        public Builder callRecordingStatus(CallRecordingStatus callRecordingStatus) {
            this.callRecordingStatus = callRecordingStatus;
            this.changedFields = changedFields.add("callRecordingStatus");
            return this;
        }

        public Builder callRecordingUrl(String callRecordingUrl) {
            this.callRecordingUrl = callRecordingUrl;
            this.changedFields = changedFields.add("callRecordingUrl");
            return this;
        }

        public Builder initiator(IdentitySet initiator) {
            this.initiator = initiator;
            this.changedFields = changedFields.add("initiator");
            return this;
        }

        public Builder meetingOrganizer(IdentitySet meetingOrganizer) {
            this.meetingOrganizer = meetingOrganizer;
            this.changedFields = changedFields.add("meetingOrganizer");
            return this;
        }

        public CallRecordingEventMessageDetail build() {
            CallRecordingEventMessageDetail _x = new CallRecordingEventMessageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecordingEventMessageDetail";
            _x.callId = callId;
            _x.callRecordingDisplayName = callRecordingDisplayName;
            _x.callRecordingDuration = callRecordingDuration;
            _x.callRecordingStatus = callRecordingStatus;
            _x.callRecordingUrl = callRecordingUrl;
            _x.initiator = initiator;
            _x.meetingOrganizer = meetingOrganizer;
            return _x;
        }
    }

    private CallRecordingEventMessageDetail _copy() {
        CallRecordingEventMessageDetail _x = new CallRecordingEventMessageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.callId = callId;
        _x.callRecordingDisplayName = callRecordingDisplayName;
        _x.callRecordingDuration = callRecordingDuration;
        _x.callRecordingStatus = callRecordingStatus;
        _x.callRecordingUrl = callRecordingUrl;
        _x.initiator = initiator;
        _x.meetingOrganizer = meetingOrganizer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallRecordingEventMessageDetail[");
        b.append("callId=");
        b.append(this.callId);
        b.append(", ");
        b.append("callRecordingDisplayName=");
        b.append(this.callRecordingDisplayName);
        b.append(", ");
        b.append("callRecordingDuration=");
        b.append(this.callRecordingDuration);
        b.append(", ");
        b.append("callRecordingStatus=");
        b.append(this.callRecordingStatus);
        b.append(", ");
        b.append("callRecordingUrl=");
        b.append(this.callRecordingUrl);
        b.append(", ");
        b.append("initiator=");
        b.append(this.initiator);
        b.append(", ");
        b.append("meetingOrganizer=");
        b.append(this.meetingOrganizer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
