package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "album", 
    "childCount"})
@JsonInclude(Include.NON_NULL)
public class Bundle implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("album")
    protected Album album;

    @JsonProperty("childCount")
    protected Integer childCount;

    protected Bundle() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bundle";
    }

    @Property(name="album")
    @JsonIgnore
    public Optional<Album> getAlbum() {
        return Optional.ofNullable(album);
    }

    public Bundle withAlbum(Album album) {
        Bundle _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bundle");
        _x.album = album;
        return _x;
    }

    @Property(name="childCount")
    @JsonIgnore
    public Optional<Integer> getChildCount() {
        return Optional.ofNullable(childCount);
    }

    public Bundle withChildCount(Integer childCount) {
        Bundle _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bundle");
        _x.childCount = childCount;
        return _x;
    }

    public Bundle withUnmappedField(String name, Object value) {
        Bundle _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Album album;
        private Integer childCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder album(Album album) {
            this.album = album;
            this.changedFields = changedFields.add("album");
            return this;
        }

        public Builder childCount(Integer childCount) {
            this.childCount = childCount;
            this.changedFields = changedFields.add("childCount");
            return this;
        }

        public Bundle build() {
            Bundle _x = new Bundle();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bundle";
            _x.album = album;
            _x.childCount = childCount;
            return _x;
        }
    }

    private Bundle _copy() {
        Bundle _x = new Bundle();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.album = album;
        _x.childCount = childCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bundle[");
        b.append("album=");
        b.append(this.album);
        b.append(", ");
        b.append("childCount=");
        b.append(this.childCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
