package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "from", 
    "to"})
@JsonInclude(Include.NON_NULL)
public class BucketAggregationRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("from")
    protected String from;

    @JsonProperty("to")
    protected String to;

    protected BucketAggregationRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bucketAggregationRange";
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<String> getFrom() {
        return Optional.ofNullable(from);
    }

    public BucketAggregationRange withFrom(String from) {
        BucketAggregationRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationRange");
        _x.from = from;
        return _x;
    }

    @Property(name="to")
    @JsonIgnore
    public Optional<String> getTo() {
        return Optional.ofNullable(to);
    }

    public BucketAggregationRange withTo(String to) {
        BucketAggregationRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationRange");
        _x.to = to;
        return _x;
    }

    public BucketAggregationRange withUnmappedField(String name, Object value) {
        BucketAggregationRange _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String from;
        private String to;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder from(String from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            this.changedFields = changedFields.add("to");
            return this;
        }

        public BucketAggregationRange build() {
            BucketAggregationRange _x = new BucketAggregationRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bucketAggregationRange";
            _x.from = from;
            _x.to = to;
            return _x;
        }
    }

    private BucketAggregationRange _copy() {
        BucketAggregationRange _x = new BucketAggregationRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.from = from;
        _x.to = to;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BucketAggregationRange[");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("to=");
        b.append(this.to);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
