package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BucketAggregationSortProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "isDescending", 
    "minimumCount", 
    "prefixFilter", 
    "ranges", 
    "sortBy"})
@JsonInclude(Include.NON_NULL)
public class BucketAggregationDefinition implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isDescending")
    protected Boolean isDescending;

    @JsonProperty("minimumCount")
    protected Integer minimumCount;

    @JsonProperty("prefixFilter")
    protected String prefixFilter;

    @JsonProperty("ranges")
    protected List<BucketAggregationRange> ranges;

    @JsonProperty("ranges@nextLink")
    protected String rangesNextLink;

    @JsonProperty("sortBy")
    protected BucketAggregationSortProperty sortBy;

    protected BucketAggregationDefinition() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bucketAggregationDefinition";
    }

    @Property(name="isDescending")
    @JsonIgnore
    public Optional<Boolean> getIsDescending() {
        return Optional.ofNullable(isDescending);
    }

    public BucketAggregationDefinition withIsDescending(Boolean isDescending) {
        BucketAggregationDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationDefinition");
        _x.isDescending = isDescending;
        return _x;
    }

    @Property(name="minimumCount")
    @JsonIgnore
    public Optional<Integer> getMinimumCount() {
        return Optional.ofNullable(minimumCount);
    }

    public BucketAggregationDefinition withMinimumCount(Integer minimumCount) {
        BucketAggregationDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationDefinition");
        _x.minimumCount = minimumCount;
        return _x;
    }

    @Property(name="prefixFilter")
    @JsonIgnore
    public Optional<String> getPrefixFilter() {
        return Optional.ofNullable(prefixFilter);
    }

    public BucketAggregationDefinition withPrefixFilter(String prefixFilter) {
        BucketAggregationDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationDefinition");
        _x.prefixFilter = prefixFilter;
        return _x;
    }

    @Property(name="ranges")
    @JsonIgnore
    public CollectionPage<BucketAggregationRange> getRanges() {
        return new CollectionPage<BucketAggregationRange>(contextPath, BucketAggregationRange.class, this.ranges, Optional.ofNullable(rangesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ranges")
    @JsonIgnore
    public CollectionPage<BucketAggregationRange> getRanges(HttpRequestOptions options) {
        return new CollectionPage<BucketAggregationRange>(contextPath, BucketAggregationRange.class, this.ranges, Optional.ofNullable(rangesNextLink), Collections.emptyList(), options);
    }

    @Property(name="sortBy")
    @JsonIgnore
    public Optional<BucketAggregationSortProperty> getSortBy() {
        return Optional.ofNullable(sortBy);
    }

    public BucketAggregationDefinition withSortBy(BucketAggregationSortProperty sortBy) {
        BucketAggregationDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bucketAggregationDefinition");
        _x.sortBy = sortBy;
        return _x;
    }

    public BucketAggregationDefinition withUnmappedField(String name, Object value) {
        BucketAggregationDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isDescending;
        private Integer minimumCount;
        private String prefixFilter;
        private List<BucketAggregationRange> ranges;
        private String rangesNextLink;
        private BucketAggregationSortProperty sortBy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isDescending(Boolean isDescending) {
            this.isDescending = isDescending;
            this.changedFields = changedFields.add("isDescending");
            return this;
        }

        public Builder minimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
            this.changedFields = changedFields.add("minimumCount");
            return this;
        }

        public Builder prefixFilter(String prefixFilter) {
            this.prefixFilter = prefixFilter;
            this.changedFields = changedFields.add("prefixFilter");
            return this;
        }

        public Builder ranges(List<BucketAggregationRange> ranges) {
            this.ranges = ranges;
            this.changedFields = changedFields.add("ranges");
            return this;
        }

        public Builder ranges(BucketAggregationRange... ranges) {
            return ranges(Arrays.asList(ranges));
        }

        public Builder rangesNextLink(String rangesNextLink) {
            this.rangesNextLink = rangesNextLink;
            this.changedFields = changedFields.add("ranges");
            return this;
        }

        public Builder sortBy(BucketAggregationSortProperty sortBy) {
            this.sortBy = sortBy;
            this.changedFields = changedFields.add("sortBy");
            return this;
        }

        public BucketAggregationDefinition build() {
            BucketAggregationDefinition _x = new BucketAggregationDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bucketAggregationDefinition";
            _x.isDescending = isDescending;
            _x.minimumCount = minimumCount;
            _x.prefixFilter = prefixFilter;
            _x.ranges = ranges;
            _x.rangesNextLink = rangesNextLink;
            _x.sortBy = sortBy;
            return _x;
        }
    }

    private BucketAggregationDefinition _copy() {
        BucketAggregationDefinition _x = new BucketAggregationDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isDescending = isDescending;
        _x.minimumCount = minimumCount;
        _x.prefixFilter = prefixFilter;
        _x.ranges = ranges;
        _x.sortBy = sortBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BucketAggregationDefinition[");
        b.append("isDescending=");
        b.append(this.isDescending);
        b.append(", ");
        b.append("minimumCount=");
        b.append(this.minimumCount);
        b.append(", ");
        b.append("prefixFilter=");
        b.append(this.prefixFilter);
        b.append(", ");
        b.append("ranges=");
        b.append(this.ranges);
        b.append(", ");
        b.append("sortBy=");
        b.append(this.sortBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
