package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BroadcastMeetingAudience;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedAudience", 
    "captions", 
    "isAttendeeReportEnabled", 
    "isQuestionAndAnswerEnabled", 
    "isRecordingEnabled", 
    "isVideoOnDemandEnabled"})
@JsonInclude(Include.NON_NULL)
public class BroadcastMeetingSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedAudience")
    protected BroadcastMeetingAudience allowedAudience;

    @JsonProperty("captions")
    protected BroadcastMeetingCaptionSettings captions;

    @JsonProperty("isAttendeeReportEnabled")
    protected Boolean isAttendeeReportEnabled;

    @JsonProperty("isQuestionAndAnswerEnabled")
    protected Boolean isQuestionAndAnswerEnabled;

    @JsonProperty("isRecordingEnabled")
    protected Boolean isRecordingEnabled;

    @JsonProperty("isVideoOnDemandEnabled")
    protected Boolean isVideoOnDemandEnabled;

    protected BroadcastMeetingSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.broadcastMeetingSettings";
    }

    @Property(name="allowedAudience")
    @JsonIgnore
    public Optional<BroadcastMeetingAudience> getAllowedAudience() {
        return Optional.ofNullable(allowedAudience);
    }

    public BroadcastMeetingSettings withAllowedAudience(BroadcastMeetingAudience allowedAudience) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.allowedAudience = allowedAudience;
        return _x;
    }

    @Property(name="captions")
    @JsonIgnore
    public Optional<BroadcastMeetingCaptionSettings> getCaptions() {
        return Optional.ofNullable(captions);
    }

    public BroadcastMeetingSettings withCaptions(BroadcastMeetingCaptionSettings captions) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.captions = captions;
        return _x;
    }

    @Property(name="isAttendeeReportEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsAttendeeReportEnabled() {
        return Optional.ofNullable(isAttendeeReportEnabled);
    }

    public BroadcastMeetingSettings withIsAttendeeReportEnabled(Boolean isAttendeeReportEnabled) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.isAttendeeReportEnabled = isAttendeeReportEnabled;
        return _x;
    }

    @Property(name="isQuestionAndAnswerEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsQuestionAndAnswerEnabled() {
        return Optional.ofNullable(isQuestionAndAnswerEnabled);
    }

    public BroadcastMeetingSettings withIsQuestionAndAnswerEnabled(Boolean isQuestionAndAnswerEnabled) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.isQuestionAndAnswerEnabled = isQuestionAndAnswerEnabled;
        return _x;
    }

    @Property(name="isRecordingEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsRecordingEnabled() {
        return Optional.ofNullable(isRecordingEnabled);
    }

    public BroadcastMeetingSettings withIsRecordingEnabled(Boolean isRecordingEnabled) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.isRecordingEnabled = isRecordingEnabled;
        return _x;
    }

    @Property(name="isVideoOnDemandEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsVideoOnDemandEnabled() {
        return Optional.ofNullable(isVideoOnDemandEnabled);
    }

    public BroadcastMeetingSettings withIsVideoOnDemandEnabled(Boolean isVideoOnDemandEnabled) {
        BroadcastMeetingSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.broadcastMeetingSettings");
        _x.isVideoOnDemandEnabled = isVideoOnDemandEnabled;
        return _x;
    }

    public BroadcastMeetingSettings withUnmappedField(String name, Object value) {
        BroadcastMeetingSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BroadcastMeetingAudience allowedAudience;
        private BroadcastMeetingCaptionSettings captions;
        private Boolean isAttendeeReportEnabled;
        private Boolean isQuestionAndAnswerEnabled;
        private Boolean isRecordingEnabled;
        private Boolean isVideoOnDemandEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder allowedAudience(BroadcastMeetingAudience allowedAudience) {
            this.allowedAudience = allowedAudience;
            this.changedFields = changedFields.add("allowedAudience");
            return this;
        }

        public Builder captions(BroadcastMeetingCaptionSettings captions) {
            this.captions = captions;
            this.changedFields = changedFields.add("captions");
            return this;
        }

        public Builder isAttendeeReportEnabled(Boolean isAttendeeReportEnabled) {
            this.isAttendeeReportEnabled = isAttendeeReportEnabled;
            this.changedFields = changedFields.add("isAttendeeReportEnabled");
            return this;
        }

        public Builder isQuestionAndAnswerEnabled(Boolean isQuestionAndAnswerEnabled) {
            this.isQuestionAndAnswerEnabled = isQuestionAndAnswerEnabled;
            this.changedFields = changedFields.add("isQuestionAndAnswerEnabled");
            return this;
        }

        public Builder isRecordingEnabled(Boolean isRecordingEnabled) {
            this.isRecordingEnabled = isRecordingEnabled;
            this.changedFields = changedFields.add("isRecordingEnabled");
            return this;
        }

        public Builder isVideoOnDemandEnabled(Boolean isVideoOnDemandEnabled) {
            this.isVideoOnDemandEnabled = isVideoOnDemandEnabled;
            this.changedFields = changedFields.add("isVideoOnDemandEnabled");
            return this;
        }

        public BroadcastMeetingSettings build() {
            BroadcastMeetingSettings _x = new BroadcastMeetingSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.broadcastMeetingSettings";
            _x.allowedAudience = allowedAudience;
            _x.captions = captions;
            _x.isAttendeeReportEnabled = isAttendeeReportEnabled;
            _x.isQuestionAndAnswerEnabled = isQuestionAndAnswerEnabled;
            _x.isRecordingEnabled = isRecordingEnabled;
            _x.isVideoOnDemandEnabled = isVideoOnDemandEnabled;
            return _x;
        }
    }

    private BroadcastMeetingSettings _copy() {
        BroadcastMeetingSettings _x = new BroadcastMeetingSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allowedAudience = allowedAudience;
        _x.captions = captions;
        _x.isAttendeeReportEnabled = isAttendeeReportEnabled;
        _x.isQuestionAndAnswerEnabled = isQuestionAndAnswerEnabled;
        _x.isRecordingEnabled = isRecordingEnabled;
        _x.isVideoOnDemandEnabled = isVideoOnDemandEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BroadcastMeetingSettings[");
        b.append("allowedAudience=");
        b.append(this.allowedAudience);
        b.append(", ");
        b.append("captions=");
        b.append(this.captions);
        b.append(", ");
        b.append("isAttendeeReportEnabled=");
        b.append(this.isAttendeeReportEnabled);
        b.append(", ");
        b.append("isQuestionAndAnswerEnabled=");
        b.append(this.isQuestionAndAnswerEnabled);
        b.append(", ");
        b.append("isRecordingEnabled=");
        b.append(this.isRecordingEnabled);
        b.append(", ");
        b.append("isVideoOnDemandEnabled=");
        b.append(this.isVideoOnDemandEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
