package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BookingReminderRecipients;


/**
 * <i>“This type represents when and to whom to send an e-mail reminder.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "offset", 
    "recipients"})
@JsonInclude(Include.NON_NULL)
public class BookingReminder implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("offset")
    protected Duration offset;

    @JsonProperty("recipients")
    protected BookingReminderRecipients recipients;

    protected BookingReminder() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingReminder";
    }

    /**
     * <i>“Message to send.”</i>
     * 
     * @return property message
     */
    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code message} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Message to send.”</i>
     * 
     * @param message
     *            new value of {@code message} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code message} field changed
     */
    public BookingReminder withMessage(String message) {
        BookingReminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingReminder");
        _x.message = message;
        return _x;
    }

    /**
     * <i>“How much time before an appointment the reminder should be sent.”</i>
     * 
     * @return property offset
     */
    @Property(name="offset")
    @JsonIgnore
    public Optional<Duration> getOffset() {
        return Optional.ofNullable(offset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code offset} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“How much time before an appointment the reminder should be sent.”</i>
     * 
     * @param offset
     *            new value of {@code offset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code offset} field changed
     */
    public BookingReminder withOffset(Duration offset) {
        BookingReminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingReminder");
        _x.offset = offset;
        return _x;
    }

    /**
     * <i>“Who should receive the reminder.”</i>
     * 
     * @return property recipients
     */
    @Property(name="recipients")
    @JsonIgnore
    public Optional<BookingReminderRecipients> getRecipients() {
        return Optional.ofNullable(recipients);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recipients} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Who should receive the reminder.”</i>
     * 
     * @param recipients
     *            new value of {@code recipients} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recipients} field changed
     */
    public BookingReminder withRecipients(BookingReminderRecipients recipients) {
        BookingReminder _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingReminder");
        _x.recipients = recipients;
        return _x;
    }

    public BookingReminder withUnmappedField(String name, Object value) {
        BookingReminder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private Duration offset;
        private BookingReminderRecipients recipients;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Message to send.”</i>
         * 
         * @param message
         *            value of {@code message} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        /**
         * <i>“How much time before an appointment the reminder should be sent.”</i>
         * 
         * @param offset
         *            value of {@code offset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder offset(Duration offset) {
            this.offset = offset;
            this.changedFields = changedFields.add("offset");
            return this;
        }

        /**
         * <i>“Who should receive the reminder.”</i>
         * 
         * @param recipients
         *            value of {@code recipients} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recipients(BookingReminderRecipients recipients) {
            this.recipients = recipients;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public BookingReminder build() {
            BookingReminder _x = new BookingReminder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingReminder";
            _x.message = message;
            _x.offset = offset;
            _x.recipients = recipients;
            return _x;
        }
    }

    private BookingReminder _copy() {
        BookingReminder _x = new BookingReminder();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.message = message;
        _x.offset = offset;
        _x.recipients = recipients;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingReminder[");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("offset=");
        b.append(this.offset);
        b.append(", ");
        b.append("recipients=");
        b.append(this.recipients);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
