package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isRequired", 
    "questionId"})
@JsonInclude(Include.NON_NULL)
public class BookingQuestionAssignment implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("questionId")
    protected String questionId;

    protected BookingQuestionAssignment() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingQuestionAssignment";
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public BookingQuestionAssignment withIsRequired(Boolean isRequired) {
        BookingQuestionAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAssignment");
        _x.isRequired = isRequired;
        return _x;
    }

    @Property(name="questionId")
    @JsonIgnore
    public Optional<String> getQuestionId() {
        return Optional.ofNullable(questionId);
    }

    public BookingQuestionAssignment withQuestionId(String questionId) {
        BookingQuestionAssignment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAssignment");
        _x.questionId = questionId;
        return _x;
    }

    public BookingQuestionAssignment withUnmappedField(String name, Object value) {
        BookingQuestionAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isRequired;
        private String questionId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder questionId(String questionId) {
            this.questionId = questionId;
            this.changedFields = changedFields.add("questionId");
            return this;
        }

        public BookingQuestionAssignment build() {
            BookingQuestionAssignment _x = new BookingQuestionAssignment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingQuestionAssignment";
            _x.isRequired = isRequired;
            _x.questionId = questionId;
            return _x;
        }
    }

    private BookingQuestionAssignment _copy() {
        BookingQuestionAssignment _x = new BookingQuestionAssignment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isRequired = isRequired;
        _x.questionId = questionId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingQuestionAssignment[");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("questionId=");
        b.append(this.questionId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
