package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AnswerInputType;

@JsonPropertyOrder({
    "@odata.type", 
    "answer", 
    "answerInputType", 
    "answerOptions", 
    "isRequired", 
    "question", 
    "questionId", 
    "selectedOptions"})
@JsonInclude(Include.NON_NULL)
public class BookingQuestionAnswer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("answer")
    protected String answer;

    @JsonProperty("answerInputType")
    protected AnswerInputType answerInputType;

    @JsonProperty("answerOptions")
    protected List<String> answerOptions;

    @JsonProperty("answerOptions@nextLink")
    protected String answerOptionsNextLink;

    @JsonProperty("isRequired")
    protected Boolean isRequired;

    @JsonProperty("question")
    protected String question;

    @JsonProperty("questionId")
    protected String questionId;

    @JsonProperty("selectedOptions")
    protected List<String> selectedOptions;

    @JsonProperty("selectedOptions@nextLink")
    protected String selectedOptionsNextLink;

    protected BookingQuestionAnswer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingQuestionAnswer";
    }

    @Property(name="answer")
    @JsonIgnore
    public Optional<String> getAnswer() {
        return Optional.ofNullable(answer);
    }

    public BookingQuestionAnswer withAnswer(String answer) {
        BookingQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAnswer");
        _x.answer = answer;
        return _x;
    }

    @Property(name="answerInputType")
    @JsonIgnore
    public Optional<AnswerInputType> getAnswerInputType() {
        return Optional.ofNullable(answerInputType);
    }

    public BookingQuestionAnswer withAnswerInputType(AnswerInputType answerInputType) {
        BookingQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAnswer");
        _x.answerInputType = answerInputType;
        return _x;
    }

    @Property(name="answerOptions")
    @JsonIgnore
    public CollectionPage<String> getAnswerOptions() {
        return new CollectionPage<String>(contextPath, String.class, this.answerOptions, Optional.ofNullable(answerOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="answerOptions")
    @JsonIgnore
    public CollectionPage<String> getAnswerOptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.answerOptions, Optional.ofNullable(answerOptionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRequired() {
        return Optional.ofNullable(isRequired);
    }

    public BookingQuestionAnswer withIsRequired(Boolean isRequired) {
        BookingQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAnswer");
        _x.isRequired = isRequired;
        return _x;
    }

    @Property(name="question")
    @JsonIgnore
    public Optional<String> getQuestion() {
        return Optional.ofNullable(question);
    }

    public BookingQuestionAnswer withQuestion(String question) {
        BookingQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAnswer");
        _x.question = question;
        return _x;
    }

    @Property(name="questionId")
    @JsonIgnore
    public Optional<String> getQuestionId() {
        return Optional.ofNullable(questionId);
    }

    public BookingQuestionAnswer withQuestionId(String questionId) {
        BookingQuestionAnswer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingQuestionAnswer");
        _x.questionId = questionId;
        return _x;
    }

    @Property(name="selectedOptions")
    @JsonIgnore
    public CollectionPage<String> getSelectedOptions() {
        return new CollectionPage<String>(contextPath, String.class, this.selectedOptions, Optional.ofNullable(selectedOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="selectedOptions")
    @JsonIgnore
    public CollectionPage<String> getSelectedOptions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.selectedOptions, Optional.ofNullable(selectedOptionsNextLink), Collections.emptyList(), options);
    }

    public BookingQuestionAnswer withUnmappedField(String name, Object value) {
        BookingQuestionAnswer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String answer;
        private AnswerInputType answerInputType;
        private List<String> answerOptions;
        private String answerOptionsNextLink;
        private Boolean isRequired;
        private String question;
        private String questionId;
        private List<String> selectedOptions;
        private String selectedOptionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder answer(String answer) {
            this.answer = answer;
            this.changedFields = changedFields.add("answer");
            return this;
        }

        public Builder answerInputType(AnswerInputType answerInputType) {
            this.answerInputType = answerInputType;
            this.changedFields = changedFields.add("answerInputType");
            return this;
        }

        public Builder answerOptions(List<String> answerOptions) {
            this.answerOptions = answerOptions;
            this.changedFields = changedFields.add("answerOptions");
            return this;
        }

        public Builder answerOptions(String... answerOptions) {
            return answerOptions(Arrays.asList(answerOptions));
        }

        public Builder answerOptionsNextLink(String answerOptionsNextLink) {
            this.answerOptionsNextLink = answerOptionsNextLink;
            this.changedFields = changedFields.add("answerOptions");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.changedFields = changedFields.add("isRequired");
            return this;
        }

        public Builder question(String question) {
            this.question = question;
            this.changedFields = changedFields.add("question");
            return this;
        }

        public Builder questionId(String questionId) {
            this.questionId = questionId;
            this.changedFields = changedFields.add("questionId");
            return this;
        }

        public Builder selectedOptions(List<String> selectedOptions) {
            this.selectedOptions = selectedOptions;
            this.changedFields = changedFields.add("selectedOptions");
            return this;
        }

        public Builder selectedOptions(String... selectedOptions) {
            return selectedOptions(Arrays.asList(selectedOptions));
        }

        public Builder selectedOptionsNextLink(String selectedOptionsNextLink) {
            this.selectedOptionsNextLink = selectedOptionsNextLink;
            this.changedFields = changedFields.add("selectedOptions");
            return this;
        }

        public BookingQuestionAnswer build() {
            BookingQuestionAnswer _x = new BookingQuestionAnswer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingQuestionAnswer";
            _x.answer = answer;
            _x.answerInputType = answerInputType;
            _x.answerOptions = answerOptions;
            _x.answerOptionsNextLink = answerOptionsNextLink;
            _x.isRequired = isRequired;
            _x.question = question;
            _x.questionId = questionId;
            _x.selectedOptions = selectedOptions;
            _x.selectedOptionsNextLink = selectedOptionsNextLink;
            return _x;
        }
    }

    private BookingQuestionAnswer _copy() {
        BookingQuestionAnswer _x = new BookingQuestionAnswer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.answer = answer;
        _x.answerInputType = answerInputType;
        _x.answerOptions = answerOptions;
        _x.isRequired = isRequired;
        _x.question = question;
        _x.questionId = questionId;
        _x.selectedOptions = selectedOptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingQuestionAnswer[");
        b.append("answer=");
        b.append(this.answer);
        b.append(", ");
        b.append("answerInputType=");
        b.append(this.answerInputType);
        b.append(", ");
        b.append("answerOptions=");
        b.append(this.answerOptions);
        b.append(", ");
        b.append("isRequired=");
        b.append(this.isRequired);
        b.append(", ");
        b.append("question=");
        b.append(this.question);
        b.append(", ");
        b.append("questionId=");
        b.append(this.questionId);
        b.append(", ");
        b.append("selectedOptions=");
        b.append(this.selectedOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
