package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BitLockerEncryptionMethod;


/**
 * <i>“BitLocker Removable Drive Policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "blockCrossOrganizationWriteAccess", 
    "encryptionMethod", 
    "requireEncryptionForWriteAccess"})
@JsonInclude(Include.NON_NULL)
public class BitLockerRemovableDrivePolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("blockCrossOrganizationWriteAccess")
    protected Boolean blockCrossOrganizationWriteAccess;

    @JsonProperty("encryptionMethod")
    protected BitLockerEncryptionMethod encryptionMethod;

    @JsonProperty("requireEncryptionForWriteAccess")
    protected Boolean requireEncryptionForWriteAccess;

    protected BitLockerRemovableDrivePolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitLockerRemovableDrivePolicy";
    }

    /**
     * <i>“This policy setting determines whether BitLocker protection is required for
     * removable data drives to be writable on a computer.”</i>
     * 
     * @return property blockCrossOrganizationWriteAccess
     */
    @Property(name="blockCrossOrganizationWriteAccess")
    @JsonIgnore
    public Optional<Boolean> getBlockCrossOrganizationWriteAccess() {
        return Optional.ofNullable(blockCrossOrganizationWriteAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockCrossOrganizationWriteAccess} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting determines whether BitLocker protection is required for
     * removable data drives to be writable on a computer.”</i>
     * 
     * @param blockCrossOrganizationWriteAccess
     *            new value of {@code blockCrossOrganizationWriteAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockCrossOrganizationWriteAccess} field changed
     */
    public BitLockerRemovableDrivePolicy withBlockCrossOrganizationWriteAccess(Boolean blockCrossOrganizationWriteAccess) {
        BitLockerRemovableDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRemovableDrivePolicy");
        _x.blockCrossOrganizationWriteAccess = blockCrossOrganizationWriteAccess;
        return _x;
    }

    /**
     * <i>“Select the encryption method for removable  drives.”</i>
     * 
     * @return property encryptionMethod
     */
    @Property(name="encryptionMethod")
    @JsonIgnore
    public Optional<BitLockerEncryptionMethod> getEncryptionMethod() {
        return Optional.ofNullable(encryptionMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionMethod}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Select the encryption method for removable  drives.”</i>
     * 
     * @param encryptionMethod
     *            new value of {@code encryptionMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionMethod} field changed
     */
    public BitLockerRemovableDrivePolicy withEncryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
        BitLockerRemovableDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRemovableDrivePolicy");
        _x.encryptionMethod = encryptionMethod;
        return _x;
    }

    /**
     * <i>“Indicates whether to block write access to devices configured in another
     * organization.  If requireEncryptionForWriteAccess is false, this value does not
     * affect.”</i>
     * 
     * @return property requireEncryptionForWriteAccess
     */
    @Property(name="requireEncryptionForWriteAccess")
    @JsonIgnore
    public Optional<Boolean> getRequireEncryptionForWriteAccess() {
        return Optional.ofNullable(requireEncryptionForWriteAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireEncryptionForWriteAccess} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether to block write access to devices configured in another
     * organization.  If requireEncryptionForWriteAccess is false, this value does not
     * affect.”</i>
     * 
     * @param requireEncryptionForWriteAccess
     *            new value of {@code requireEncryptionForWriteAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireEncryptionForWriteAccess} field changed
     */
    public BitLockerRemovableDrivePolicy withRequireEncryptionForWriteAccess(Boolean requireEncryptionForWriteAccess) {
        BitLockerRemovableDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRemovableDrivePolicy");
        _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
        return _x;
    }

    public BitLockerRemovableDrivePolicy withUnmappedField(String name, Object value) {
        BitLockerRemovableDrivePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean blockCrossOrganizationWriteAccess;
        private BitLockerEncryptionMethod encryptionMethod;
        private Boolean requireEncryptionForWriteAccess;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“This policy setting determines whether BitLocker protection is required for
         * removable data drives to be writable on a computer.”</i>
         * 
         * @param blockCrossOrganizationWriteAccess
         *            value of {@code blockCrossOrganizationWriteAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockCrossOrganizationWriteAccess(Boolean blockCrossOrganizationWriteAccess) {
            this.blockCrossOrganizationWriteAccess = blockCrossOrganizationWriteAccess;
            this.changedFields = changedFields.add("blockCrossOrganizationWriteAccess");
            return this;
        }

        /**
         * <i>“Select the encryption method for removable  drives.”</i>
         * 
         * @param encryptionMethod
         *            value of {@code encryptionMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            this.changedFields = changedFields.add("encryptionMethod");
            return this;
        }

        /**
         * <i>“Indicates whether to block write access to devices configured in another
         * organization.  If requireEncryptionForWriteAccess is false, this value does not
         * affect.”</i>
         * 
         * @param requireEncryptionForWriteAccess
         *            value of {@code requireEncryptionForWriteAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireEncryptionForWriteAccess(Boolean requireEncryptionForWriteAccess) {
            this.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
            this.changedFields = changedFields.add("requireEncryptionForWriteAccess");
            return this;
        }

        public BitLockerRemovableDrivePolicy build() {
            BitLockerRemovableDrivePolicy _x = new BitLockerRemovableDrivePolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bitLockerRemovableDrivePolicy";
            _x.blockCrossOrganizationWriteAccess = blockCrossOrganizationWriteAccess;
            _x.encryptionMethod = encryptionMethod;
            _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
            return _x;
        }
    }

    private BitLockerRemovableDrivePolicy _copy() {
        BitLockerRemovableDrivePolicy _x = new BitLockerRemovableDrivePolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.blockCrossOrganizationWriteAccess = blockCrossOrganizationWriteAccess;
        _x.encryptionMethod = encryptionMethod;
        _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BitLockerRemovableDrivePolicy[");
        b.append("blockCrossOrganizationWriteAccess=");
        b.append(this.blockCrossOrganizationWriteAccess);
        b.append(", ");
        b.append("encryptionMethod=");
        b.append(this.encryptionMethod);
        b.append(", ");
        b.append("requireEncryptionForWriteAccess=");
        b.append(this.requireEncryptionForWriteAccess);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
