package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.BitLockerRecoveryInformationType;
import odata.msgraph.client.beta.enums.ConfigurationUsage;


/**
 * <i>“BitLocker Recovery Options.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "blockDataRecoveryAgent", 
    "enableBitLockerAfterRecoveryInformationToStore", 
    "enableRecoveryInformationSaveToStore", 
    "hideRecoveryOptions", 
    "recoveryInformationToStore", 
    "recoveryKeyUsage", 
    "recoveryPasswordUsage"})
@JsonInclude(Include.NON_NULL)
public class BitLockerRecoveryOptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("blockDataRecoveryAgent")
    protected Boolean blockDataRecoveryAgent;

    @JsonProperty("enableBitLockerAfterRecoveryInformationToStore")
    protected Boolean enableBitLockerAfterRecoveryInformationToStore;

    @JsonProperty("enableRecoveryInformationSaveToStore")
    protected Boolean enableRecoveryInformationSaveToStore;

    @JsonProperty("hideRecoveryOptions")
    protected Boolean hideRecoveryOptions;

    @JsonProperty("recoveryInformationToStore")
    protected BitLockerRecoveryInformationType recoveryInformationToStore;

    @JsonProperty("recoveryKeyUsage")
    protected ConfigurationUsage recoveryKeyUsage;

    @JsonProperty("recoveryPasswordUsage")
    protected ConfigurationUsage recoveryPasswordUsage;

    protected BitLockerRecoveryOptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitLockerRecoveryOptions";
    }

    /**
     * <i>“Indicates whether to block certificate-based data recovery agent.”</i>
     * 
     * @return property blockDataRecoveryAgent
     */
    @Property(name="blockDataRecoveryAgent")
    @JsonIgnore
    public Optional<Boolean> getBlockDataRecoveryAgent() {
        return Optional.ofNullable(blockDataRecoveryAgent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockDataRecoveryAgent} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether to block certificate-based data recovery agent.”</i>
     * 
     * @param blockDataRecoveryAgent
     *            new value of {@code blockDataRecoveryAgent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockDataRecoveryAgent} field changed
     */
    public BitLockerRecoveryOptions withBlockDataRecoveryAgent(Boolean blockDataRecoveryAgent) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.blockDataRecoveryAgent = blockDataRecoveryAgent;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to enable BitLocker until recovery information is
     * stored in AD DS.”</i>
     * 
     * @return property enableBitLockerAfterRecoveryInformationToStore
     */
    @Property(name="enableBitLockerAfterRecoveryInformationToStore")
    @JsonIgnore
    public Optional<Boolean> getEnableBitLockerAfterRecoveryInformationToStore() {
        return Optional.ofNullable(enableBitLockerAfterRecoveryInformationToStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableBitLockerAfterRecoveryInformationToStore} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to enable BitLocker until recovery information is
     * stored in AD DS.”</i>
     * 
     * @param enableBitLockerAfterRecoveryInformationToStore
     *            new value of {@code enableBitLockerAfterRecoveryInformationToStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableBitLockerAfterRecoveryInformationToStore} field changed
     */
    public BitLockerRecoveryOptions withEnableBitLockerAfterRecoveryInformationToStore(Boolean enableBitLockerAfterRecoveryInformationToStore) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.enableBitLockerAfterRecoveryInformationToStore = enableBitLockerAfterRecoveryInformationToStore;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow BitLocker recovery information to store in AD
     * DS.”</i>
     * 
     * @return property enableRecoveryInformationSaveToStore
     */
    @Property(name="enableRecoveryInformationSaveToStore")
    @JsonIgnore
    public Optional<Boolean> getEnableRecoveryInformationSaveToStore() {
        return Optional.ofNullable(enableRecoveryInformationSaveToStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableRecoveryInformationSaveToStore} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow BitLocker recovery information to store in AD
     * DS.”</i>
     * 
     * @param enableRecoveryInformationSaveToStore
     *            new value of {@code enableRecoveryInformationSaveToStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableRecoveryInformationSaveToStore} field changed
     */
    public BitLockerRecoveryOptions withEnableRecoveryInformationSaveToStore(Boolean enableRecoveryInformationSaveToStore) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.enableRecoveryInformationSaveToStore = enableRecoveryInformationSaveToStore;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow showing recovery options in BitLocker Setup
     * Wizard for fixed or system disk.”</i>
     * 
     * @return property hideRecoveryOptions
     */
    @Property(name="hideRecoveryOptions")
    @JsonIgnore
    public Optional<Boolean> getHideRecoveryOptions() {
        return Optional.ofNullable(hideRecoveryOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hideRecoveryOptions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow showing recovery options in BitLocker Setup
     * Wizard for fixed or system disk.”</i>
     * 
     * @param hideRecoveryOptions
     *            new value of {@code hideRecoveryOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hideRecoveryOptions} field changed
     */
    public BitLockerRecoveryOptions withHideRecoveryOptions(Boolean hideRecoveryOptions) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.hideRecoveryOptions = hideRecoveryOptions;
        return _x;
    }

    /**
     * <i>“Configure what pieces of BitLocker recovery information are stored to AD DS.”</i>
     * 
     * @return property recoveryInformationToStore
     */
    @Property(name="recoveryInformationToStore")
    @JsonIgnore
    public Optional<BitLockerRecoveryInformationType> getRecoveryInformationToStore() {
        return Optional.ofNullable(recoveryInformationToStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * recoveryInformationToStore} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Configure what pieces of BitLocker recovery information are stored to AD DS.”</i>
     * 
     * @param recoveryInformationToStore
     *            new value of {@code recoveryInformationToStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recoveryInformationToStore} field changed
     */
    public BitLockerRecoveryOptions withRecoveryInformationToStore(BitLockerRecoveryInformationType recoveryInformationToStore) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.recoveryInformationToStore = recoveryInformationToStore;
        return _x;
    }

    /**
     * <i>“Indicates whether users are allowed or required to generate a 256-bit recovery
     * key for fixed or system disk.”</i>
     * 
     * @return property recoveryKeyUsage
     */
    @Property(name="recoveryKeyUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getRecoveryKeyUsage() {
        return Optional.ofNullable(recoveryKeyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recoveryKeyUsage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether users are allowed or required to generate a 256-bit recovery
     * key for fixed or system disk.”</i>
     * 
     * @param recoveryKeyUsage
     *            new value of {@code recoveryKeyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recoveryKeyUsage} field changed
     */
    public BitLockerRecoveryOptions withRecoveryKeyUsage(ConfigurationUsage recoveryKeyUsage) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.recoveryKeyUsage = recoveryKeyUsage;
        return _x;
    }

    /**
     * <i>“Indicates whether users are allowed or required to generate a 48-digit recovery
     * password for fixed or system disk.”</i>
     * 
     * @return property recoveryPasswordUsage
     */
    @Property(name="recoveryPasswordUsage")
    @JsonIgnore
    public Optional<ConfigurationUsage> getRecoveryPasswordUsage() {
        return Optional.ofNullable(recoveryPasswordUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * recoveryPasswordUsage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether users are allowed or required to generate a 48-digit recovery
     * password for fixed or system disk.”</i>
     * 
     * @param recoveryPasswordUsage
     *            new value of {@code recoveryPasswordUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recoveryPasswordUsage} field changed
     */
    public BitLockerRecoveryOptions withRecoveryPasswordUsage(ConfigurationUsage recoveryPasswordUsage) {
        BitLockerRecoveryOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerRecoveryOptions");
        _x.recoveryPasswordUsage = recoveryPasswordUsage;
        return _x;
    }

    public BitLockerRecoveryOptions withUnmappedField(String name, Object value) {
        BitLockerRecoveryOptions _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean blockDataRecoveryAgent;
        private Boolean enableBitLockerAfterRecoveryInformationToStore;
        private Boolean enableRecoveryInformationSaveToStore;
        private Boolean hideRecoveryOptions;
        private BitLockerRecoveryInformationType recoveryInformationToStore;
        private ConfigurationUsage recoveryKeyUsage;
        private ConfigurationUsage recoveryPasswordUsage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Indicates whether to block certificate-based data recovery agent.”</i>
         * 
         * @param blockDataRecoveryAgent
         *            value of {@code blockDataRecoveryAgent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockDataRecoveryAgent(Boolean blockDataRecoveryAgent) {
            this.blockDataRecoveryAgent = blockDataRecoveryAgent;
            this.changedFields = changedFields.add("blockDataRecoveryAgent");
            return this;
        }

        /**
         * <i>“Indicates whether or not to enable BitLocker until recovery information is
         * stored in AD DS.”</i>
         * 
         * @param enableBitLockerAfterRecoveryInformationToStore
         *            value of {@code enableBitLockerAfterRecoveryInformationToStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableBitLockerAfterRecoveryInformationToStore(Boolean enableBitLockerAfterRecoveryInformationToStore) {
            this.enableBitLockerAfterRecoveryInformationToStore = enableBitLockerAfterRecoveryInformationToStore;
            this.changedFields = changedFields.add("enableBitLockerAfterRecoveryInformationToStore");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow BitLocker recovery information to store in AD
         * DS.”</i>
         * 
         * @param enableRecoveryInformationSaveToStore
         *            value of {@code enableRecoveryInformationSaveToStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableRecoveryInformationSaveToStore(Boolean enableRecoveryInformationSaveToStore) {
            this.enableRecoveryInformationSaveToStore = enableRecoveryInformationSaveToStore;
            this.changedFields = changedFields.add("enableRecoveryInformationSaveToStore");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow showing recovery options in BitLocker Setup
         * Wizard for fixed or system disk.”</i>
         * 
         * @param hideRecoveryOptions
         *            value of {@code hideRecoveryOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hideRecoveryOptions(Boolean hideRecoveryOptions) {
            this.hideRecoveryOptions = hideRecoveryOptions;
            this.changedFields = changedFields.add("hideRecoveryOptions");
            return this;
        }

        /**
         * <i>“Configure what pieces of BitLocker recovery information are stored to AD DS.”</i>
         * 
         * @param recoveryInformationToStore
         *            value of {@code recoveryInformationToStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recoveryInformationToStore(BitLockerRecoveryInformationType recoveryInformationToStore) {
            this.recoveryInformationToStore = recoveryInformationToStore;
            this.changedFields = changedFields.add("recoveryInformationToStore");
            return this;
        }

        /**
         * <i>“Indicates whether users are allowed or required to generate a 256-bit recovery
         * key for fixed or system disk.”</i>
         * 
         * @param recoveryKeyUsage
         *            value of {@code recoveryKeyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recoveryKeyUsage(ConfigurationUsage recoveryKeyUsage) {
            this.recoveryKeyUsage = recoveryKeyUsage;
            this.changedFields = changedFields.add("recoveryKeyUsage");
            return this;
        }

        /**
         * <i>“Indicates whether users are allowed or required to generate a 48-digit recovery
         * password for fixed or system disk.”</i>
         * 
         * @param recoveryPasswordUsage
         *            value of {@code recoveryPasswordUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recoveryPasswordUsage(ConfigurationUsage recoveryPasswordUsage) {
            this.recoveryPasswordUsage = recoveryPasswordUsage;
            this.changedFields = changedFields.add("recoveryPasswordUsage");
            return this;
        }

        public BitLockerRecoveryOptions build() {
            BitLockerRecoveryOptions _x = new BitLockerRecoveryOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bitLockerRecoveryOptions";
            _x.blockDataRecoveryAgent = blockDataRecoveryAgent;
            _x.enableBitLockerAfterRecoveryInformationToStore = enableBitLockerAfterRecoveryInformationToStore;
            _x.enableRecoveryInformationSaveToStore = enableRecoveryInformationSaveToStore;
            _x.hideRecoveryOptions = hideRecoveryOptions;
            _x.recoveryInformationToStore = recoveryInformationToStore;
            _x.recoveryKeyUsage = recoveryKeyUsage;
            _x.recoveryPasswordUsage = recoveryPasswordUsage;
            return _x;
        }
    }

    private BitLockerRecoveryOptions _copy() {
        BitLockerRecoveryOptions _x = new BitLockerRecoveryOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.blockDataRecoveryAgent = blockDataRecoveryAgent;
        _x.enableBitLockerAfterRecoveryInformationToStore = enableBitLockerAfterRecoveryInformationToStore;
        _x.enableRecoveryInformationSaveToStore = enableRecoveryInformationSaveToStore;
        _x.hideRecoveryOptions = hideRecoveryOptions;
        _x.recoveryInformationToStore = recoveryInformationToStore;
        _x.recoveryKeyUsage = recoveryKeyUsage;
        _x.recoveryPasswordUsage = recoveryPasswordUsage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BitLockerRecoveryOptions[");
        b.append("blockDataRecoveryAgent=");
        b.append(this.blockDataRecoveryAgent);
        b.append(", ");
        b.append("enableBitLockerAfterRecoveryInformationToStore=");
        b.append(this.enableBitLockerAfterRecoveryInformationToStore);
        b.append(", ");
        b.append("enableRecoveryInformationSaveToStore=");
        b.append(this.enableRecoveryInformationSaveToStore);
        b.append(", ");
        b.append("hideRecoveryOptions=");
        b.append(this.hideRecoveryOptions);
        b.append(", ");
        b.append("recoveryInformationToStore=");
        b.append(this.recoveryInformationToStore);
        b.append(", ");
        b.append("recoveryKeyUsage=");
        b.append(this.recoveryKeyUsage);
        b.append(", ");
        b.append("recoveryPasswordUsage=");
        b.append(this.recoveryPasswordUsage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
